/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.db;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.db.DatabaseAdapter;
import com.definesys.mpaas.query.oracle.ProcedureExecutor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DefaultDatabaseAdapter
implements DatabaseAdapter {
    @Autowired
    private MpaasQueryConfig config;
    @Autowired
    private DataSource dataSource;

    @Override
    public List<Object> executeProcedure(String funOrProc, String name, Object[] paramAndResult) {
        if (!"oracle".equalsIgnoreCase(this.config.getDBVendor())) {
            throw new UnsupportedOperationException("procedure only oracle database support");
        }
        List<Object> result = null;
        try {
            Connection connection = this.dataSource.getConnection();
            ProcedureExecutor executor = new ProcedureExecutor(connection);
            result = executor.call(funOrProc, name, paramAndResult);
            executor.close();
        }
        catch (SQLException e2) {
            e2.printStackTrace();
            throw new MpaasRuntimeException("executeProcedure error:" + e2.getMessage());
        }
        return result;
    }
}

