/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.db;

import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.db.Dialect;
import com.definesys.mpaas.query.db.MySqlDialect;
import com.definesys.mpaas.query.db.OracleDialect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DialectFactory {
    @Autowired
    private MpaasQueryConfig config;
    @Autowired(required=false)
    @Qualifier(value="NOSQL_DIALECT")
    private Dialect nosqlDialect;

    public Dialect buildDatabaseDialect() {
        String dbVendor = this.config.getDBVendor();
        if ("Oracle".equalsIgnoreCase(dbVendor)) {
            return new OracleDialect();
        }
        if ("MySql".equalsIgnoreCase(dbVendor)) {
            return new MySqlDialect();
        }
        if ("MongoDB".equalsIgnoreCase(dbVendor)) {
            return this.nosqlDialect;
        }
        return new OracleDialect();
    }
}

