/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.db;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.query.Clause;
import com.definesys.mpaas.query.annotation.RowID;
import com.definesys.mpaas.query.annotation.RowIDType;
import com.definesys.mpaas.query.db.ClauseSQL;
import com.definesys.mpaas.query.db.Dialect;
import com.definesys.mpaas.query.db.KeyValue;

public class MySqlDialect
implements Dialect {
    public static final String PAGE_SQL_TEMPLATE = "select * from (%s)ya limit %d,%d";

    @Override
    public ClauseSQL handleClause(Clause clause) {
        ClauseSQL cl = new ClauseSQL(ClauseSQL.VARIABLE);
        if (!("is null".equals(clause.getOp()) || "is not null".equals(clause.getOp()) || "var is null".equals(clause.getOp()) || "var is not null".equals(clause.getOp()) || clause != null && clause.getValues() != null && clause.getValues().get(0) != null)) {
            cl.setType(ClauseSQL.NONE);
            return cl;
        }
        String sql = null;
        String op = clause.getOp();
        String fmt = clause.getVariableFormat();
        if (fmt == null) {
            fmt = ":%s";
        }
        String var = String.format(fmt, clause.getVariable());
        if ("like".equals(op)) {
            clause.setValue("%" + clause.getValue() + "%");
            sql = String.format("%s like %s", clause.getField(), var);
        } else if ("=".equals(op)) {
            sql = String.format("%s = %s", clause.getField(), var);
        } else if ("!=".equals(op)) {
            sql = String.format("%s <> %s", clause.getField(), var);
        } else if (">".equals(op)) {
            sql = String.format("%s > %s", clause.getField(), var);
        } else if (">=".equals(op)) {
            sql = String.format("%s >= %s", clause.getField(), var);
        } else if ("<".equals(op)) {
            sql = String.format("%s < %s", clause.getField(), var);
        } else if ("<=".equals(op)) {
            sql = String.format("%s <= %s", clause.getField(), var);
        } else if ("^".equals(op)) {
            clause.setValue(clause.getValue() + "%");
            sql = String.format("%s like %s", clause.getField(), var);
        } else if ("$".equals(op)) {
            clause.setValue("%" + clause.getValue());
            sql = String.format("%s like %s", clause.getField(), var);
        } else if ("is null".equals(op)) {
            cl.setType(ClauseSQL.PURE);
            sql = String.format("%s is null", clause.getField());
        } else if ("is not null".equals(op)) {
            cl.setType(ClauseSQL.PURE);
            sql = String.format("%s is not null", clause.getField());
        } else if ("not like".equals(op)) {
            clause.setValue("%" + clause.getValue() + "%");
            sql = String.format("%s not like %s", clause.getField(), var);
        } else if ("in".equals(op) || "not in".equals(op)) {
            String s2;
            StringBuffer sb = new StringBuffer();
            cl.setType(ClauseSQL.PURE);
            for (Object v2 : clause.getValues()) {
                if (v2 == null) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (v2 instanceof String) {
                    sb.append("'");
                    sb.append(v2);
                    sb.append("'");
                    continue;
                }
                sb.append(v2);
            }
            String string = s2 = "in".equals(op) ? "in" : "not in";
            sql = sb.length() == 0 ? "1=1" : String.format("%s %s(%s)", clause.getField(), s2, sb.toString());
        } else if ("between".equals(op)) {
            sql = String.format("%s between %s_begin and %s_end", clause.getField(), var, var);
        }
        cl.setSqlClause(sql);
        return cl;
    }

    @Override
    public String buildPageQuery(String sql, Integer page, Integer pageSize) {
        if (page == null || pageSize == null) {
            return sql;
        }
        int begin = (page - 1) * pageSize;
        return String.format(PAGE_SQL_TEMPLATE, sql, begin, pageSize);
    }

    @Override
    public KeyValue generateKey(String tableName, String column, RowID rowID) {
        RowIDType rowIDType = rowID.type();
        KeyValue key = new KeyValue();
        if (rowIDType == RowIDType.AUTO_INCREMENT || rowIDType == RowIDType.AUTO) {
            key.setStyle("AUTOINCREMENT");
        } else if (rowIDType == RowIDType.UUID) {
            key.setStyle("VALUE");
            key.setValue(MpaasUtil.generateUniqueKey());
        } else {
            throw new MpaasRuntimeException("unsupport RowIDType:" + (Object)((Object)rowID.type()));
        }
        return key;
    }
}

