/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.db;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.log.SWordLogger;
import com.definesys.mpaas.query.db.DefaultDatabaseAdapter;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.model.QueryInfo;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.sql2o.Connection;
import org.sql2o.Query;
import org.sql2o.Sql2o;

@Component
public class Sql2ODatabaseAdapter
extends DefaultDatabaseAdapter {
    @Autowired(required=false)
    private Sql2o sql2o;
    @Autowired
    private SWordLogger logger;

    @Override
    public <T> List<T> executeQuery(QueryInfo queryInfo, String sql, List<Parameter> prames, Class<T> result) {
        try (Connection conn = this.sql2o.open();){
            this.logger.debug("executeQuery sql==>%s", sql);
            Query query = conn.createQuery(sql, false);
            for (Parameter p2 : prames) {
                query.addParameter(p2.getName(), p2.getValue());
            }
            List<T> list = query.executeAndFetch(result);
            return list;
        }
    }

    @Override
    public List<Map<String, Object>> executeQueryAsList(QueryInfo queryInfo, String sql, List<Parameter> prames) {
        try (Connection conn = this.sql2o.open();){
            this.logger.debug("executeQueryAsList sql==>%s", sql);
            Query query = conn.createQuery(sql, false);
            for (Parameter p2 : prames) {
                query.addParameter(p2.getName(), p2.getValue());
            }
            List<Map<String, Object>> list = query.executeAndFetchTable().asList();
            return list;
        }
    }

    @Override
    public int executeDelete(QueryInfo queryInfo, String sql, List<Parameter> params) {
        this.logger.debug("executeDelete sql==>%s", sql);
        if (params == null || params.size() == 0) {
            throw MpaasRuntimeException.fromCode("SW-180229", new Object[0]);
        }
        return this.executeUpdate(queryInfo, sql, params);
    }

    @Override
    public int executeUpdate(QueryInfo queryInfo, String sql, List<Parameter> params) {
        this.logger.debug("executeUpdate sql==>%s", sql);
        try (Connection conn = this.sql2o.open();){
            this.logger.info(sql, new Object[0]);
            conn.getJdbcConnection().setAutoCommit(false);
            Query query = conn.createQuery(sql, false);
            for (Parameter p2 : params) {
                query.addParameter(p2.getName(), p2.getValue());
            }
            int result = query.executeUpdate().getResult();
            conn.commit();
            int n2 = result;
            return n2;
        }
    }

    @Override
    public Object executeInsert(QueryInfo queryInfo, String sql, List<Parameter> params, String ... keyColumns) {
        this.logger.debug("executeInsert sql==>%s", sql);
        Connection conn = this.sql2o.open();
        if (keyColumns == null) {
            keyColumns = new String[]{};
        }
        Object key = null;
        try {
            this.logger.info(sql, new Object[0]);
            conn.getJdbcConnection().setAutoCommit(false);
            Query query = conn.createQuery(sql, keyColumns);
            for (Parameter p2 : params) {
                query.addParameter(p2.getName(), p2.getValue());
            }
            if (keyColumns != null) {
                key = query.executeUpdate().getKey();
            }
            conn.commit();
            Object object = key;
            return object;
        }
        catch (Exception e2) {
            conn.rollback();
            throw new MpaasRuntimeException(e2);
        }
        finally {
            conn.close();
        }
    }
}

