/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.util;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TypeUtil {
    public static List<SimpleDateFormat> dateFormat = new ArrayList<SimpleDateFormat>();

    public static void main(String[] cmd) {
        Date value = TypeUtil.convert("2018/09/12", Date.class);
        System.out.println(value);
    }

    public static <T> T convert(Object value, Class<T> target) {
        if (value == null) {
            return null;
        }
        if (value.getClass().getName().equals(target.getName())) {
            return (T)value;
        }
        Object result = null;
        if (target == Integer.class) {
            result = TypeUtil.integerConvert(value);
        } else if (target == String.class) {
            result = TypeUtil.stringConvert(value);
        } else if (target == Date.class) {
            result = TypeUtil.dateConvert(value);
        } else if (target == Double.class) {
            result = TypeUtil.doubleConvert(value);
        } else if (target == Float.class) {
            result = TypeUtil.floatConvert(value);
        } else if (target == Long.class) {
            result = TypeUtil.longConvert(value);
        }
        return (T)result;
    }

    public static Integer integerConvert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> clazz = value.getClass();
        Integer result = null;
        boolean bok = false;
        if (clazz == Integer.class || clazz == String.class || clazz == Double.class || clazz == BigDecimal.class || clazz == Float.class || clazz == Long.class) {
            bok = true;
        }
        if (!bok) {
            throw new MpaasRuntimeException("can not convert from %s==>%s to Integer", clazz.getName(), value.toString());
        }
        if (clazz == Integer.class) {
            result = (Integer)value;
        } else if (clazz == Long.class) {
            result = ((Long)value).intValue();
        } else if (clazz == String.class) {
            try {
                result = Integer.parseInt(value.toString());
            }
            catch (Exception ex) {
                throw new MpaasRuntimeException("can not convert from %s==>%s to Integer", clazz.getName(), value.toString());
            }
        } else if (clazz == BigDecimal.class) {
            result = ((BigDecimal)value).intValue();
        } else if (clazz == Float.class) {
            result = ((Float)value).intValue();
        } else if (clazz == Double.class) {
            result = ((Double)value).intValue();
        }
        return result;
    }

    public static Long longConvert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> clazz = value.getClass();
        Long result = null;
        boolean bok = false;
        if (clazz == Integer.class || clazz == String.class || clazz == Double.class || clazz == BigDecimal.class || clazz == Float.class || clazz == Long.class || clazz == java.sql.Date.class || clazz == Timestamp.class || clazz == Time.class) {
            bok = true;
        }
        if (!bok) {
            throw new MpaasRuntimeException("can not convert from %s==>%s to Long", clazz.getName(), value.toString());
        }
        if (clazz == Long.class) {
            result = (Long)value;
        } else if (clazz == Integer.class) {
            result = ((Integer)value).longValue();
        } else if (clazz == String.class) {
            try {
                result = Long.parseLong(value.toString());
            }
            catch (Exception ex) {
                throw new MpaasRuntimeException("can not convert from %s==>%s to Long", clazz.getName(), value.toString());
            }
        } else if (clazz == BigDecimal.class) {
            result = ((BigDecimal)value).longValue();
        } else if (clazz == Float.class) {
            result = ((Float)value).longValue();
        } else if (clazz == Double.class) {
            result = ((Double)value).longValue();
        } else if (clazz == java.sql.Date.class) {
            result = ((java.sql.Date)value).getTime();
        } else if (clazz == Timestamp.class) {
            result = ((Timestamp)value).getTime();
        } else if (clazz == Time.class) {
            result = ((Time)value).getTime();
        }
        return result;
    }

    public static String stringConvert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> clazz = value.getClass();
        String result = null;
        if (clazz == byte[].class) {
            try {
                result = new String((byte[])value, "UTF-8");
            }
            catch (UnsupportedEncodingException e2) {
                e2.printStackTrace();
            }
        } else {
            result = String.valueOf(value);
        }
        return result;
    }

    public static Double doubleConvert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> clazz = value.getClass();
        Double result = null;
        boolean bok = false;
        if (clazz == Integer.class || clazz == String.class || clazz == Double.class || clazz == BigDecimal.class || clazz == Float.class || clazz == Long.class) {
            bok = true;
        }
        if (!bok) {
            throw new MpaasRuntimeException("can not convert from %s==>%s to Double", clazz.getName(), value.toString());
        }
        if (clazz == Integer.class) {
            result = ((Integer)value).doubleValue();
        } else if (clazz == Long.class) {
            result = ((Long)value).doubleValue();
        } else if (clazz == String.class) {
            try {
                result = Double.parseDouble(value.toString());
            }
            catch (Exception ex) {
                throw new MpaasRuntimeException("can not convert from %s==>%s to Double", clazz.getName(), value.toString());
            }
        } else if (clazz == BigDecimal.class) {
            result = ((BigDecimal)value).doubleValue();
        } else if (clazz == Float.class) {
            result = ((Float)value).doubleValue();
        }
        return result;
    }

    public static Float floatConvert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> clazz = value.getClass();
        Float result = null;
        boolean bok = false;
        if (clazz == Integer.class || clazz == String.class || clazz == Double.class || clazz == BigDecimal.class || clazz == Float.class || clazz == Long.class) {
            bok = true;
        }
        if (!bok) {
            throw new MpaasRuntimeException("can not convert from %s==>%s to Float", clazz.getName(), value.toString());
        }
        if (clazz == Integer.class) {
            result = Float.valueOf(((Integer)value).floatValue());
        } else if (clazz == Long.class) {
            result = Float.valueOf(((Long)value).floatValue());
        } else if (clazz == String.class) {
            try {
                result = Float.valueOf(Float.parseFloat(value.toString()));
            }
            catch (Exception ex) {
                throw new MpaasRuntimeException("can not convert from %s==>%s to Float", clazz.getName(), value.toString());
            }
        } else if (clazz == BigDecimal.class) {
            result = Float.valueOf(((BigDecimal)value).floatValue());
        } else if (clazz == Float.class) {
            result = (Float)value;
        }
        return result;
    }

    public static Date dateConvert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> clazz = value.getClass();
        Date result = null;
        boolean bok = false;
        if (clazz == java.sql.Date.class || clazz == Timestamp.class || clazz == Time.class || clazz == String.class || clazz == Long.class) {
            bok = true;
        }
        if (!bok) {
            throw new MpaasRuntimeException("can not convert from %s==>%s to Date", clazz.getName(), value.toString());
        }
        if (clazz == java.sql.Date.class) {
            result = new Date(((java.sql.Date)value).getTime());
        } else if (clazz == Long.class) {
            result = new Date((Long)value);
        } else if (clazz == String.class) {
            result = TypeUtil.dateParse(value.toString());
        } else if (clazz == Timestamp.class) {
            result = new Date(((Timestamp)value).getTime());
        } else if (clazz == Time.class) {
            result = new Date(((Time)value).getTime());
        }
        return result;
    }

    public static Date dateParse(String value) {
        if (value == null) {
            return null;
        }
        Date result = null;
        for (SimpleDateFormat f2 : dateFormat) {
            try {
                result = f2.parse(value);
                break;
            }
            catch (ParseException e2) {
                e2.printStackTrace();
            }
        }
        if (result == null) {
            throw new MpaasRuntimeException("can not convert from String==>%s to Date", value.toString());
        }
        return result;
    }

    public static boolean isBasicType(Class clazz) {
        return clazz == Integer.class || clazz == String.class || clazz == Date.class || clazz == Double.class || clazz == Float.class || clazz == Long.class;
    }

    static {
        dateFormat.add(new SimpleDateFormat("yyyy/MM/dd"));
        dateFormat.add(new SimpleDateFormat("yyyy-MM-dd"));
        dateFormat.add(new SimpleDateFormat("yy/MM/dd"));
        dateFormat.add(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"));
        dateFormat.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        dateFormat.add(new SimpleDateFormat("yy-MM-dd HH:mm:ss"));
    }
}

