/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import org.dhatim.fastexcel.BorderElement;
import org.dhatim.fastexcel.BorderSide;
import org.dhatim.fastexcel.Writer;

class Border {
    protected static final Border NONE = new Border();
    final Map<BorderSide, BorderElement> elements = new EnumMap<BorderSide, BorderElement>(BorderSide.class);

    Border() {
        this(BorderElement.NONE, BorderElement.NONE, BorderElement.NONE, BorderElement.NONE, BorderElement.NONE);
    }

    Border(BorderElement element) {
        this(element, element, element, element, BorderElement.NONE);
    }

    Border(BorderElement left, BorderElement right, BorderElement top, BorderElement bottom, BorderElement diagonal) {
        this.elements.put(BorderSide.TOP, top);
        this.elements.put(BorderSide.LEFT, left);
        this.elements.put(BorderSide.BOTTOM, bottom);
        this.elements.put(BorderSide.RIGHT, right);
        this.elements.put(BorderSide.DIAGONAL, diagonal);
    }

    void setElement(BorderSide side, BorderElement element) {
        this.elements.put(side, element);
    }

    static Border fromStyleAndColor(String style, String color) {
        BorderElement element = new BorderElement(style, color);
        return new Border(element, element, element, element, BorderElement.NONE);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj != null && obj.getClass() == this.getClass()) {
            Border other = (Border)obj;
            result = this.elements.equals(other.elements);
        } else {
            result = false;
        }
        return result;
    }

    void write(Writer w2) throws IOException {
        w2.append("<border>");
        this.elements.get((Object)BorderSide.LEFT).write("left", w2);
        this.elements.get((Object)BorderSide.RIGHT).write("right", w2);
        this.elements.get((Object)BorderSide.TOP).write("top", w2);
        this.elements.get((Object)BorderSide.BOTTOM).write("bottom", w2);
        this.elements.get((Object)BorderSide.DIAGONAL).write("diagonal", w2);
        w2.append("</border>");
    }
}

