/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public final class TimestampUtil {
    private static final LocalDateTime EPOCH_1900 = LocalDateTime.of(1900, 1, 1, 0, 0, 0, 0);

    private TimestampUtil() {
    }

    public static Double convertDate(Date date) {
        return TimestampUtil.convertDate(date, ZoneId.systemDefault());
    }

    public static Double convertDate(LocalDate date) {
        return (double)ChronoUnit.DAYS.between(EPOCH_1900.toLocalDate(), date) + 2.0;
    }

    public static Double convertZonedDateTime(ChronoZonedDateTime zdt) {
        return TimestampUtil.convertDate(Date.from(zdt.toInstant()), zdt.getZone());
    }

    private static Double convertDate(Date date, ZoneId timezone) {
        LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), timezone);
        Duration duration = Duration.between(EPOCH_1900, ldt);
        return (double)duration.getSeconds() / 86400.0 + (double)duration.getNano() / 8.64E13 + 2.0;
    }
}

