/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.dhatim.fastexcel.Alignment;
import org.dhatim.fastexcel.Border;
import org.dhatim.fastexcel.CachedString;
import org.dhatim.fastexcel.Fill;
import org.dhatim.fastexcel.Font;
import org.dhatim.fastexcel.StringCache;
import org.dhatim.fastexcel.StyleCache;
import org.dhatim.fastexcel.ThrowingConsumer;
import org.dhatim.fastexcel.Worksheet;
import org.dhatim.fastexcel.Writer;

public class Workbook {
    private final String applicationName;
    private final String applicationVersion;
    private final List<Worksheet> worksheets = new ArrayList<Worksheet>();
    private final StringCache stringCache = new StringCache();
    private final StyleCache styleCache = new StyleCache();
    private final ZipOutputStream os;
    private final Writer writer;

    public Workbook(OutputStream os, String applicationName) {
        this.os = new ZipOutputStream(os, Charset.forName("UTF-8"));
        this.writer = new Writer(this.os);
        this.applicationName = Objects.requireNonNull(applicationName);
        this.applicationVersion = "1.0";
    }

    public void sortWorksheets(Comparator<Worksheet> comparator) {
        this.worksheets.sort(comparator);
    }

    public void finish() throws IOException {
        for (Worksheet ws : this.worksheets) {
            ws.finish();
        }
        this.writeFile("[Content_Types].xml", w2 -> {
            w2.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\"><Default Extension=\"rels\" ContentType=\"application/vnd.openxmlformats-package.relationships+xml\"/><Default Extension=\"xml\" ContentType=\"application/xml\"/><Override PartName=\"/xl/sharedStrings.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml\"/><Override PartName=\"/xl/styles.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml\"/><Override PartName=\"/xl/workbook.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml\"/>");
            for (Worksheet ws : this.worksheets) {
                w2.append("<Override PartName=\"/xl/worksheets/sheet").append(this.getIndex(ws)).append(".xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml\"/>");
            }
            w2.append("<Override PartName=\"/docProps/core.xml\" ContentType=\"application/vnd.openxmlformats-package.core-properties+xml\"/><Override PartName=\"/docProps/app.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.extended-properties+xml\"/></Types>");
        });
        this.writeFile("docProps/app.xml", w2 -> w2.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Properties xmlns=\"http://schemas.openxmlformats.org/officeDocument/2006/extended-properties\"><Application>").appendEscaped(this.applicationName).append("</Application>").append(this.applicationVersion == null ? "" : "<AppVersion>" + this.applicationVersion + "</AppVersion>").append("</Properties>"));
        this.writeFile("docProps/core.xml", w2 -> w2.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><cp:coreProperties xmlns:cp=\"http://schemas.openxmlformats.org/package/2006/metadata/core-properties\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><dcterms:created xsi:type=\"dcterms:W3CDTF\">").append(LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)).append("Z</dcterms:created><dc:creator>").appendEscaped(this.applicationName).append("</dc:creator></cp:coreProperties>"));
        this.writeFile("_rels/.rels", w2 -> w2.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\"><Relationship Id=\"rId3\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties\" Target=\"docProps/app.xml\"/><Relationship Id=\"rId2\" Type=\"http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties\" Target=\"docProps/core.xml\"/><Relationship Id=\"rId1\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument\" Target=\"xl/workbook.xml\"/></Relationships>"));
        this.writeFile("xl/workbook.xml", w2 -> {
            w2.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><workbook xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"><workbookPr date1904=\"false\"/><bookViews><workbookView activeTab=\"0\"/></bookViews><sheets>");
            for (Worksheet ws : this.worksheets) {
                w2.append("<sheet name=\"").appendEscaped(ws.getName()).append("\" r:id=\"rId").append(this.getIndex(ws) + 2).append("\" sheetId=\"").append(this.getIndex(ws)).append("\"/>");
            }
            w2.append("</sheets></workbook>");
        });
        this.writeFile("xl/sharedStrings.xml", this.stringCache::write);
        this.writeFile("xl/styles.xml", this.styleCache::write);
        this.writeFile("xl/_rels/workbook.xml.rels", w2 -> {
            w2.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\"><Relationship Id=\"rId1\" Target=\"sharedStrings.xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings\"/><Relationship Id=\"rId2\" Target=\"styles.xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles\"/>");
            for (Worksheet ws : this.worksheets) {
                w2.append("<Relationship Id=\"rId").append(this.getIndex(ws) + 2).append("\" Target=\"worksheets/sheet").append(this.getIndex(ws)).append(".xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet\"/>");
            }
            w2.append("</Relationships>");
        });
        this.os.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFile(String name, ThrowingConsumer<Writer> consumer) throws IOException {
        ZipOutputStream zipOutputStream = this.os;
        synchronized (zipOutputStream) {
            this.os.putNextEntry(new ZipEntry(name));
            consumer.accept(this.writer);
            this.writer.flush();
            this.os.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(String name) throws IOException {
        ZipOutputStream zipOutputStream = this.os;
        synchronized (zipOutputStream) {
            this.os.putNextEntry(new ZipEntry(name));
        }
    }

    public Writer getWriter() {
        return this.writer;
    }

    CachedString cacheString(String s2) {
        return this.stringCache.cacheString(s2);
    }

    int mergeAndCacheStyle(int currentStyle, String numberingFormat, Font font, Fill fill, Border border, Alignment alignment) {
        return this.styleCache.mergeAndCacheStyle(currentStyle, numberingFormat, font, fill, border, alignment);
    }

    int cacheAlternateShadingFillColor(Fill fill) {
        return this.styleCache.cacheDxf(fill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getIndex(Worksheet ws) {
        List<Worksheet> list = this.worksheets;
        synchronized (list) {
            return this.worksheets.indexOf(ws) + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Worksheet newWorksheet(String name) {
        String sheetName = name.replaceAll("[/\\\\\\?\\*\\]\\[\\:]", "-");
        if (sheetName.length() > 31) {
            sheetName = sheetName.substring(0, 31);
        }
        List<Worksheet> list = this.worksheets;
        synchronized (list) {
            int number = 1;
            Set names = this.worksheets.stream().map(Worksheet::getName).collect(Collectors.toSet());
            while (names.contains(sheetName)) {
                String suffix = String.format(Locale.ROOT, "_%d", number);
                sheetName = sheetName.length() + suffix.length() > 31 ? sheetName.substring(0, 31 - suffix.length()) + suffix : sheetName + suffix;
                ++number;
            }
            Worksheet worksheet = new Worksheet(this, sheetName);
            this.worksheets.add(worksheet);
            return worksheet;
        }
    }
}

