/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

class Writer {
    private final OutputStream os;
    private final StringBuilder sb;

    Writer(OutputStream os) {
        this.os = os;
        this.sb = new StringBuilder(524288);
    }

    Writer append(String s2) throws IOException {
        return this.append(s2, false);
    }

    Writer appendEscaped(String s2) throws IOException {
        return this.append(s2, true);
    }

    private void escape(int c2) {
        if (!(c2 == 9 || c2 == 10 || c2 == 13 || c2 >= 32 && c2 <= 55295 || c2 >= 57344 && c2 <= 65533 || c2 >= 65536 && c2 <= 0x10FFFF)) {
            return;
        }
        switch (c2) {
            case 60: {
                this.sb.append("&lt;");
                break;
            }
            case 62: {
                this.sb.append("&gt;");
                break;
            }
            case 38: {
                this.sb.append("&amp;");
                break;
            }
            case 39: {
                this.sb.append("&apos;");
                break;
            }
            case 34: {
                this.sb.append("&quot;");
                break;
            }
            default: {
                if (c2 > 126 || c2 < 32) {
                    this.sb.append("&#x").append(Integer.toHexString(c2)).append(';');
                    break;
                }
                this.sb.append((char)c2);
            }
        }
    }

    private Writer append(String s2, boolean escape) throws IOException {
        if (escape) {
            int codePoint;
            for (int offset = 0; offset < s2.length(); offset += Character.charCount(codePoint)) {
                codePoint = s2.codePointAt(offset);
                this.escape(codePoint);
            }
        } else {
            this.sb.append(s2);
        }
        this.check();
        return this;
    }

    private void check() throws IOException {
        if (this.sb.capacity() - this.sb.length() < 1024) {
            this.flush();
        }
    }

    Writer append(char c2) throws IOException {
        this.sb.append(c2);
        this.check();
        return this;
    }

    Writer append(int n2) throws IOException {
        this.sb.append(n2);
        this.check();
        return this;
    }

    Writer append(long n2) throws IOException {
        this.sb.append(n2);
        this.check();
        return this;
    }

    Writer append(double n2) throws IOException {
        this.sb.append(n2);
        this.check();
        return this;
    }

    void flush() throws IOException {
        this.os.write(this.sb.toString().getBytes(StandardCharsets.UTF_8));
        this.sb.setLength(0);
    }
}

