/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import org.sql2o.converters.ConverterBase;
import org.sql2o.converters.ConverterException;
import org.sql2o.tools.IOUtils;

public class StringConverter
extends ConverterBase<String> {
    @Override
    public String convert(Object val) throws ConverterException {
        if (val == null) {
            return null;
        }
        if (val instanceof Clob) {
            Clob clobVal = (Clob)val;
            try {
                String string = clobVal.getSubString(1L, (int)clobVal.length());
                return string;
            }
            catch (SQLException e2) {
                throw new ConverterException("error converting clob to String", e2);
            }
            finally {
                try {
                    clobVal.free();
                }
                catch (Throwable throwable) {}
            }
        }
        if (val instanceof Reader) {
            Reader reader = (Reader)val;
            try {
                String e2 = IOUtils.toString(reader);
                return e2;
            }
            catch (IOException e3) {
                throw new ConverterException("error converting reader to String", e3);
            }
            finally {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return val.toString().trim();
    }
}

