/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.log;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import java.util.ResourceBundle;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SWordLogger {
    public static final String LOGER_NAME = "SWordLogger";
    public static final String LOGER_RB_NAME = "SWordLoggerResource";
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.definesys.mpaas.log.messages.Messages");
    private String logLevel;
    private Level javaLogLevel;
    private String mode;
    private boolean isLogHandlerAdded = false;
    private boolean isExceptionLogHandlerAdded = false;

    @Autowired
    public SWordLogger(@Value(value="${mpaas.logging.level:INFO}") String logLevel, @Value(value="${mpaas.mode:PROD}") String mode) {
        this.logLevel = logLevel;
        this.mode = mode;
        if ("DEV".equalsIgnoreCase(mode)) {
            this.javaLogLevel = Level.FINER;
            return;
        }
        if ("INFO".equalsIgnoreCase(logLevel)) {
            this.javaLogLevel = Level.INFO;
        } else if ("OFF".equalsIgnoreCase(logLevel)) {
            this.javaLogLevel = Level.OFF;
        } else if ("SEVERE".equalsIgnoreCase(logLevel)) {
            this.javaLogLevel = Level.SEVERE;
        } else if ("WARNING".equalsIgnoreCase(logLevel)) {
            this.javaLogLevel = Level.WARNING;
        } else if ("FINE".equalsIgnoreCase(logLevel)) {
            this.javaLogLevel = Level.FINE;
        } else if ("ALL".equalsIgnoreCase(logLevel)) {
            this.javaLogLevel = Level.FINER;
        } else if ("DEBUG".equalsIgnoreCase(logLevel)) {
            this.javaLogLevel = Level.FINER;
        } else {
            throw new MpaasRuntimeException("invalid log level:" + logLevel);
        }
    }

    public void error(String format, Object ... params) {
        this.doLog(Level.SEVERE, format, params);
    }

    public void warn(String format, Object ... params) {
        this.doLog(Level.WARNING, format, params);
    }

    public void info(String format, Object ... params) {
        this.doLog(Level.INFO, format, params);
    }

    public void debug(String format, Object ... params) {
        this.doLog(Level.FINE, format, params);
    }

    public void fine(String format, Object ... params) {
        this.doLog(Level.FINE, format, params);
    }

    public void exception(String exceptionCode, Object ... params) {
        Handler[] handlers;
        Logger logger = Logger.getLogger(LOGER_RB_NAME);
        logger.setLevel(this.javaLogLevel);
        if ("DEV".equalsIgnoreCase(this.mode) && !this.isExceptionLogHandlerAdded) {
            logger.addHandler(new ConsoleHandler());
            this.isExceptionLogHandlerAdded = true;
        }
        for (Handler h : handlers = logger.getHandlers()) {
            h.setLevel(this.javaLogLevel);
        }
        StackTraceElement[] sts = Thread.currentThread().getStackTrace();
        if (sts.length > 2) {
            StackTraceElement st = sts[2];
            logger.logrb(Level.SEVERE, st.getClassName(), st.getMethodName(), resourceBundle, exceptionCode, params);
        }
    }

    private void doLog(Level level, String msg, Object ... params) {
        Handler[] handlers;
        msg = String.format(msg, params);
        Logger logger = Logger.getLogger(LOGER_NAME);
        logger.setLevel(this.javaLogLevel);
        if ("DEV".equalsIgnoreCase(this.mode) && !this.isLogHandlerAdded) {
            logger.addHandler(new ConsoleHandler());
            this.isLogHandlerAdded = true;
        }
        for (Handler h : handlers = logger.getHandlers()) {
            h.setLevel(this.javaLogLevel);
        }
        StackTraceElement[] sts = Thread.currentThread().getStackTrace();
        if (sts.length > 2) {
            StackTraceElement st = sts[2];
            logger.logp(level, st.getClassName(), st.getMethodName(), msg, new Object[0]);
        }
    }
}

