/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.pojo;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.pojo.PojoField;
import com.definesys.mpaas.query.annotation.Lookup;
import com.definesys.mpaas.query.annotation.Lookups;
import com.definesys.mpaas.query.annotation.SQL;
import com.definesys.mpaas.query.annotation.SQLQuery;
import com.definesys.mpaas.query.annotation.Style;
import com.definesys.mpaas.query.annotation.SystemColumnType;
import com.definesys.mpaas.query.annotation.Table;
import com.definesys.mpaas.query.db.Clause;
import com.definesys.mpaas.query.lookup.LookupInfo;
import com.definesys.mpaas.query.model.RowData;
import com.definesys.mpaas.query.model.RowValue;
import com.definesys.mpaas.query.session.MpaasSession;
import com.definesys.mpaas.query.util.MpaasQueryUtil;
import com.definesys.mpaas.query.util.TypeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class PojoMeta {
    private String tableName;
    private Boolean upper2Underline = true;
    private List<PojoField> pojoFields = new ArrayList<PojoField>();
    private Map<String, SQL> sqlQuerys;
    private Class pojo;
    private List<LookupInfo> lookups;
    private Boolean haveLink = false;

    public PojoMeta(Object param) {
        if (param instanceof Class) {
            this.pojo = (Class)param;
            this.init((Class)param);
        } else if (param instanceof RowData) {
            this.pojo = param.getClass();
            this.initMap((RowData)param);
        }
    }

    public void init(Class clazz) {
        SQLQuery sqlQuery;
        Table t;
        Class tmp;
        Hashtable<String, Method> getter = new Hashtable<String, Method>();
        Hashtable<String, Method> setter = new Hashtable<String, Method>();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (tmp = clazz; tmp != null && !tmp.getClass().getName().equals(Object.class.getName()); tmp = tmp.getSuperclass()) {
            methods.addAll(Arrays.asList(tmp.getDeclaredMethods()));
        }
        for (Method m : methods) {
            if (m.getName().startsWith("get") || m.getName().startsWith("is")) {
                getter.put(m.getName().toLowerCase(), m);
                continue;
            }
            if (!m.getName().startsWith("set")) continue;
            setter.put(m.getName().toLowerCase(), m);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (tmp = clazz; tmp != null && !tmp.getClass().getName().equals(Object.class.getName()); tmp = tmp.getSuperclass()) {
            fields.addAll(Arrays.asList(tmp.getDeclaredFields()));
        }
        Style style = clazz.getAnnotation(Style.class);
        if (style != null) {
            this.upper2Underline = style.Upper2Underline();
        }
        for (Field f : fields) {
            Method m1 = (Method)getter.get("get" + f.getName().toLowerCase());
            if (m1 == null && f.getType() == Boolean.class) {
                m1 = (Method)getter.get("is" + f.getName().toLowerCase());
            }
            PojoField f1 = new PojoField(f, m1, (Method)setter.get("set" + f.getName().toLowerCase()));
            this.pojoFields.add(f1);
            if (this.haveLink.booleanValue() || f1.getLink() == null) continue;
            this.haveLink = true;
        }
        this.tableName = clazz.getSimpleName();
        if (this.upper2Underline.booleanValue()) {
            this.tableName = MpaasQueryUtil.upper2Underline(this.tableName);
        }
        if ((t = clazz.getAnnotation(Table.class)) != null && t.value() != null) {
            this.tableName = t.value();
        }
        if ((sqlQuery = clazz.getAnnotation(SQLQuery.class)) != null) {
            SQL[] sqls;
            this.sqlQuerys = new HashMap<String, SQL>();
            for (SQL sql : sqls = sqlQuery.value()) {
                this.sqlQuerys.put(sql.view().toLowerCase(), sql);
            }
        }
        this.lookup(clazz);
    }

    private void lookup(Class clazz) {
        Lookup lov = clazz.getAnnotation(Lookup.class);
        Lookups lovs = clazz.getAnnotation(Lookups.class);
        if (lovs != null) {
            this.lookups = LookupInfo.lookups(lovs);
        }
        if (this.lookups == null) {
            this.lookups = new ArrayList<LookupInfo>();
        }
        if (lov != null) {
            this.lookups.add(LookupInfo.lookup(lov));
        }
        for (PojoField f : this.pojoFields) {
            if (f.getLookup() == null) continue;
            LookupInfo lookupInfo = LookupInfo.lookup(f.getLookup());
            lookupInfo.setTo(f.getFieldName());
            this.lookups.add(lookupInfo);
        }
    }

    private void initMap(RowData clazz) {
        Map<String, RowValue> row = clazz.getRow();
        for (String key : row.keySet()) {
            RowValue rv = row.get(key);
            PojoField f = new PojoField(key);
            f.setRowIDInfo(rv.getRowIDInfo());
            this.pojoFields.add(f);
        }
    }

    public List<Clause> updateActionInit(Object pojo, String[] fields) {
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        List<PojoField> updateFields = this.pojoFields;
        if (fields != null && fields.length > 0) {
            updateFields = new ArrayList<PojoField>();
            for (String v : fields) {
                PojoField f = this.findPojoField(v);
                if (f == null) {
                    throw new MpaasRuntimeException("field:" + v + " not found");
                }
                updateFields.add(f);
            }
        }
        try {
            for (PojoField f : updateFields) {
                if (f.isKeyField().booleanValue() || !f.isDBColumn().booleanValue()) continue;
                SystemColumnType st = f.getSystemColumnType();
                String columnName = f.getSqlColumnName(this.upper2Underline);
                if (st != null) continue;
                Object value = f.getValue(pojo);
                if (value == null) {
                    Clause c = new Clause(columnName, null);
                    c.setTag(String.format("%s = null", columnName));
                    clauses.add(c);
                    continue;
                }
                clauses.add(new Clause(columnName, value));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        clauses.addAll(this.updateSystemField(pojo));
        return clauses;
    }

    private List<Clause> updateSystemField(Object pojo) {
        String user = MpaasSession.getCurrentUser();
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        for (PojoField f : this.pojoFields) {
            Method setMethod;
            SystemColumnType st = f.getSystemColumnType();
            String columnName = f.getSqlColumnName(this.upper2Underline);
            if (st == null || (setMethod = f.setter()) == null) continue;
            try {
                if (SystemColumnType.LASTUPDATE_BY == st) {
                    setMethod.invoke(pojo, user);
                    clauses.add(new Clause(columnName, user));
                    continue;
                }
                if (SystemColumnType.LASTUPDATE_ON == st) {
                    setMethod.invoke(pojo, MpaasQueryUtil.currentDate());
                    clauses.add(new Clause(columnName, MpaasQueryUtil.currentDate()));
                    continue;
                }
                if (SystemColumnType.OBJECT_VERSION != st) continue;
                Clause c = new Clause(columnName, null);
                c.setTag(String.format("%s = %s+1", columnName, columnName));
                clauses.add(c);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return clauses;
    }

    private String getterName(Field f) {
        String name = f.getName().toLowerCase();
        if (f.getType() == Boolean.class) {
            return "is" + name.substring(0, 1) + name.substring(1);
        }
        return "get" + name.substring(0, 1) + name.substring(1);
    }

    private String setterName(Field f) {
        String name = f.getName().toLowerCase();
        return "set" + name.substring(0, 1) + name.substring(1);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Boolean getUpper2Underline() {
        return this.upper2Underline;
    }

    public void setUpper2Underline(Boolean upper2Underline) {
        this.upper2Underline = upper2Underline;
    }

    public List<PojoField> getPojoFields() {
        return this.pojoFields;
    }

    public List<PojoField> getDatabaseFields() {
        ArrayList<PojoField> fs = new ArrayList<PojoField>();
        for (PojoField f : this.pojoFields) {
            if (!f.isDBColumn().booleanValue()) continue;
            fs.add(f);
        }
        return fs;
    }

    public void setPojoFields(List<PojoField> pojoFields) {
        this.pojoFields = pojoFields;
    }

    public PojoField findPojoField(String name) {
        for (PojoField f : this.pojoFields) {
            if (f.getSqlColumnName(this.upper2Underline).equalsIgnoreCase(name)) {
                return f;
            }
            if (f.getField() == null || !f.getField().getName().equalsIgnoreCase(name)) continue;
            return f;
        }
        return null;
    }

    public PojoField getRowIdField() {
        List<PojoField> fields = this.getPojoFields();
        for (PojoField f : fields) {
            if (!f.isRowId().booleanValue()) continue;
            return f;
        }
        return null;
    }

    public String getFieldDBName(String name) {
        PojoField p = this.findPojoField(name);
        if (p == null) {
            throw new MpaasRuntimeException("can not find field " + name);
        }
        return p.getSqlColumnName(this.upper2Underline);
    }

    public Map<String, SQL> getSqlQuerys() {
        return this.sqlQuerys;
    }

    public String findViewSQL(String view) {
        if (this.sqlQuerys == null) {
            return null;
        }
        SQL sql = this.sqlQuerys.get(view.toLowerCase());
        if (sql != null) {
            return sql.sql();
        }
        return null;
    }

    public Object keyAssign(Object key, Object pojo) {
        PojoField rowIdField = this.getRowIdField();
        if (key != null && rowIdField != null && rowIdField.getValue(pojo) == null) {
            try {
                rowIdField.setValue(pojo, TypeUtil.convert(key, rowIdField.getField().getType()));
            }
            catch (Throwable ex) {
                LoggerFactory.getLogger((String)"keyassign").warn(ex.getMessage());
            }
        }
        if (key == null && rowIdField != null) {
            key = rowIdField.getValue(pojo);
        }
        return key;
    }

    public List<Object> keysAssign(List<Object> keys, Object pojo) {
        if (pojo == null) {
            return keys;
        }
        if (!(pojo instanceof Collection)) {
            throw new MpaasRuntimeException("pojo must be instance of collection");
        }
        ArrayList<Object> rs = new ArrayList<Object>();
        Collection list = (Collection)pojo;
        int index = 0;
        for (Object item : list) {
            Object k = keys != null && keys.size() > index ? keys.get(index) : null;
            k = this.keyAssign(k, item);
            rs.add(k);
            ++index;
        }
        return keys;
    }

    public Class getPojo() {
        return this.pojo;
    }

    public void setSqlQuerys(Map<String, SQL> sqlQuerys) {
        this.sqlQuerys = sqlQuerys;
    }

    public void setPojo(Class pojo) {
        this.pojo = pojo;
    }

    public List<LookupInfo> getLookups() {
        return this.lookups;
    }

    public Boolean haveLink() {
        return this.haveLink;
    }
}

