/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.log.SWordLogger;
import com.definesys.mpaas.pojo.PojoCache;
import com.definesys.mpaas.pojo.PojoField;
import com.definesys.mpaas.pojo.PojoMeta;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.db.Clause;
import com.definesys.mpaas.query.db.ConjunctionPosition;
import com.definesys.mpaas.query.db.DatabaseAdapter;
import com.definesys.mpaas.query.db.DatabaseAdapterFactory;
import com.definesys.mpaas.query.db.Dialect;
import com.definesys.mpaas.query.db.DialectFactory;
import com.definesys.mpaas.query.db.PageQueryResult;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.executor.DeleteExecutor;
import com.definesys.mpaas.query.executor.ExecuteResult;
import com.definesys.mpaas.query.executor.ExportExecutor;
import com.definesys.mpaas.query.executor.InsertExecutor;
import com.definesys.mpaas.query.executor.PageQueryExecutor;
import com.definesys.mpaas.query.executor.QueryExecutor;
import com.definesys.mpaas.query.executor.UpdateExecutor;
import com.definesys.mpaas.query.model.BasePojo;
import com.definesys.mpaas.query.model.QueryInfo;
import com.definesys.mpaas.query.model.RowData;
import com.definesys.mpaas.query.util.MpaasQueryUtil;
import com.definesys.mpaas.query.util.TypeUtil;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MpaasQuery {
    private String sql;
    private String countSQL;
    private Integer page;
    private Integer pageSize;
    private String table;
    private Object pojo;
    private Class pojoClazz;
    private Boolean upper2Underline;
    private String clauseConjuction = "and";
    private String excelFileName = "excel.xlsx";
    private Integer rowVersion;
    private String viewName;
    private boolean viewQueryMode = false;
    private boolean fullUpdate = true;
    private List<Clause> clauses = new ArrayList<Clause>();
    private List<Parameter> params = new ArrayList<Parameter>();
    private List<Clause> updateField = new ArrayList<Clause>();
    private List<Parameter> orderby = new ArrayList<Parameter>();
    private List<Clause> variables = new ArrayList<Clause>();
    private Set<String> selectFields;
    private Set<String> unSelectFields;
    private Set<String> includeFields;
    private Set<String> excludeFields;
    private String groupby;
    private String distinct;
    private Dialect dialect;
    private DatabaseAdapter dbAdapter;
    private String[] updateFieldNames;
    private String rowid;
    private PojoMeta pojoInfo;
    private List<ConjunctionPosition> groupConIndex = new ArrayList<ConjunctionPosition>();
    private boolean viewConverted = false;
    private MpaasQueryConfig config;
    private SWordLogger logger;
    private int clausePosition = 0;
    private Boolean emptyResult = false;

    @Autowired
    public MpaasQuery(DialectFactory dialectFactory, DatabaseAdapterFactory databaseAdapterFactory, MpaasQueryConfig config, SWordLogger logger) {
        Dialect dialect;
        this.dialect = dialect = dialectFactory.buildDatabaseDialect();
        this.dbAdapter = databaseAdapterFactory.buildDatabaseAdapter();
        this.config = config;
        this.logger = logger;
        this.pageSize(this.config.PAGE_SIZE);
    }

    public MpaasQuery(Dialect dialect, DatabaseAdapter dbAdapter, MpaasQueryConfig config, SWordLogger logger) {
        this.dialect = dialect;
        this.dbAdapter = dbAdapter;
        this.config = config;
        this.logger = logger;
    }

    public MpaasQuery clone() {
        return new MpaasQuery(this.dialect, this.dbAdapter, this.config, this.logger);
    }

    public MpaasQuery addClause(String name, String op, Object ... value) {
        value = this.preHandleValue(value);
        if (!("is null".equals(op) || "is not null".equals(op) || "var is null".equals(op) || "var is not null".equals(op))) {
            if (value == null) {
                return this;
            }
            boolean bok = false;
            for (Object ob : value) {
                if (ob == null) continue;
                bok = true;
            }
            if (!bok) {
                ++this.clausePosition;
                return this;
            }
        }
        if ("between".equals(op)) {
            value = value != null && value.length == 0 ? null : value;
            Object begin = value == null ? null : value[0];
            Object end = value == null || value.length == 1 ? null : value[1];
            this.addClause(name, ">=", begin);
            this.addClause(name, "<", end);
        } else {
            this.addClause(new Clause(name, op, this.clauseConjuction, value));
        }
        return this;
    }

    private Object[] preHandleValue(Object ... value) {
        String s;
        if (value != null && value.length == 1 && value[0] == null) {
            return null;
        }
        if (value != null && value.length == 1 && value[0] instanceof String && (s = (String)value[0]) != null && s.length() == 0) {
            value = null;
        }
        return value;
    }

    public MpaasQuery addRowIdClause(String name, String op, String value) {
        return this.addClause(name, op, this.decryptRowId(value, String.class));
    }

    public MpaasQuery rowid(String field, String rowid) {
        return this.rowid(field, rowid, true);
    }

    public MpaasQuery rowid(String field, String rowid, boolean decrypt) {
        this.rowid = rowid;
        if (decrypt) {
            return this.eq(field, this.decryptRowId(rowid, String.class));
        }
        return this.eq(field, rowid);
    }

    public MpaasQuery rowid(String rowid) {
        this.rowid = rowid;
        return this.rowid("id", rowid, false);
    }

    public MpaasQuery sql(String sql) {
        this.sql = sql;
        return this;
    }

    public MpaasQuery table(String table) {
        this.table = table;
        return this;
    }

    public MpaasQuery view(String viewName) {
        this.viewName = viewName;
        return this;
    }

    public MpaasQuery viewQueryMode(boolean enable) {
        this.viewQueryMode = enable;
        return this;
    }

    public MpaasQuery countSql(String sql) {
        this.countSQL = sql;
        return this;
    }

    public MpaasQuery page(Integer page) {
        this.page = page;
        return this;
    }

    public MpaasQuery pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public MpaasQuery update(String field, Object value) {
        this.fullUpdate = false;
        return this.update(field, value, null);
    }

    public MpaasQuery update(String fields) {
        return this.update(fields.split(","));
    }

    private MpaasQuery update(String field, Object value, Object tag) {
        int index = 0;
        Clause clause = new Clause(field, value);
        clause.setTag(tag);
        for (Clause c : this.updateField) {
            if (c.getField() == null || !c.getField().equals(clause.getField())) continue;
            ++index;
        }
        if (index > 0) {
            clause.setVariable(clause.getVariable() + "_" + index);
        }
        this.updateField.add(clause);
        return this;
    }

    public MpaasQuery update(String[] fields) {
        this.updateFieldNames = fields;
        this.fullUpdate = false;
        return this;
    }

    public MpaasQuery update(List<String> fields) {
        return this.update(fields.toArray(new String[fields.size()]));
    }

    public MpaasQuery version(Integer rowVersion) {
        this.rowVersion = rowVersion;
        return this;
    }

    public MpaasQuery bind(Object pojo) {
        if (pojo instanceof Class) {
            return this.bind((Class)pojo);
        }
        this.pojo = pojo;
        if (this.isBatchInsert()) {
            return this.bind(((Collection)pojo).toArray()[0].getClass());
        }
        return this.bind(this.pojo.getClass());
    }

    public MpaasQuery bind(Class pojoClazz) {
        return this.bind(pojoClazz, true);
    }

    private MpaasQuery bind(Class pojoClazz, boolean ignoreBasicType) {
        boolean basicType = TypeUtil.isBasicType(pojoClazz);
        if (pojoClazz == null || ignoreBasicType && basicType) {
            return this;
        }
        this.pojoClazz = pojoClazz;
        if (!basicType) {
            PojoMeta pm = this.getPojoMetaInfo();
            if (this.table == null) {
                this.table = pm.getTableName();
            }
            if (this.upper2Underline == null) {
                this.upper2Underline = pm.getUpper2Underline();
            }
        }
        return this;
    }

    private PojoMeta getPojoMetaInfo() {
        if (this.pojoClazz == null || TypeUtil.isBasicType(this.pojoClazz)) {
            return null;
        }
        if (this.pojoInfo != null) {
            return this.pojoInfo;
        }
        this.pojoInfo = this.pojo != null && this.pojo instanceof RowData ? new PojoMeta(this.pojo) : (PojoMeta)PojoCache.cache().get(this.pojoClazz.getName(), this.pojoClazz);
        return this.pojoInfo;
    }

    private void addClause(Clause clause) {
        int index = 0;
        for (Clause c : this.clauses) {
            if (!c.getField().equals(clause.getField())) continue;
            ++index;
        }
        for (Clause c : this.updateField) {
            if (!c.getField().equals(clause.getField())) continue;
            ++index;
        }
        if (index > 0) {
            clause.setVariable(clause.getVariable() + "_" + index);
        }
        clause.setPosition(this.clausePosition++);
        this.clauses.add(clause);
    }

    public <T> List<T> doQuery(Class<T> result) {
        if (this.emptyResult.booleanValue()) {
            return Collections.EMPTY_LIST;
        }
        this.bind(result, false);
        QueryExecutor executor = new QueryExecutor();
        ExecuteResult rows = executor.execute(this.buildQueryInfo());
        return rows.getTable();
    }

    public List<Map<String, Object>> doQuery() {
        if (this.emptyResult.booleanValue()) {
            return Collections.EMPTY_LIST;
        }
        QueryExecutor executor = new QueryExecutor();
        ExecuteResult rows = executor.execute(this.buildQueryInfo());
        return rows.getTable();
    }

    public <T> T doQueryFirst(Class<T> result) {
        PageQueryResult<T> rs = this.doPageQuery(1, 1, result);
        if (rs == null || rs.getResult() == null || rs.getResult().size() == 0) {
            return null;
        }
        return rs.getResult().get(0);
    }

    public Map<String, Object> doQueryFirst() {
        PageQueryResult rs = this.doPageQuery((Integer)1, 1);
        if (rs == null || rs.getResult() == null || rs.getResult().size() == 0) {
            return null;
        }
        return (Map)rs.getResult().get(0);
    }

    public PageQueryResult doPageQuery() {
        return this.doPageQuery(this.page, this.pageSize);
    }

    public PageQueryResult doPageQuery(Integer page) {
        this.page = page;
        return this.doPageQuery(this.page, this.pageSize);
    }

    public PageQueryResult doPageQuery(Integer page, Integer pageSize) {
        return this.doPageQuery(page, pageSize, null);
    }

    public <T> PageQueryResult<T> doPageQuery(Class<T> result) {
        return this.doPageQuery(this.page, this.pageSize, result);
    }

    public <T> PageQueryResult<T> doPageQuery(Integer page, Class<T> result) {
        this.page = page;
        return this.doPageQuery(this.page, this.pageSize, result);
    }

    public <T> PageQueryResult<T> doPageQuery(Integer page, Integer pageSize, Class<T> clazz) {
        if (this.emptyResult.booleanValue()) {
            return PageQueryResult.EMPTY_RESULT;
        }
        this.bind(clazz, false);
        this.page = page;
        this.pageSize = pageSize;
        PageQueryExecutor executor = new PageQueryExecutor();
        ExecuteResult result = executor.execute(this.buildQueryInfo());
        return result.getPageQueryResult();
    }

    public void doDelete() {
        DeleteExecutor executor = new DeleteExecutor();
        executor.execute(this.buildQueryInfo());
    }

    public void doDelete(Object pojo) {
        this.bind(pojo);
        this.doDelete();
    }

    public void doUpdate(Object pojo) {
        this.bind(pojo);
        this.doUpdate();
    }

    public void doUpdate() {
        UpdateExecutor executor = new UpdateExecutor(this);
        executor.execute(this.buildQueryInfo());
    }

    public Object doInsert() {
        InsertExecutor builder = new InsertExecutor();
        ExecuteResult result = builder.execute(this.buildQueryInfo());
        return result.getData();
    }

    public Object doInsert(Object pojo) {
        this.bind(pojo);
        return this.doInsert();
    }

    public Object doBatchInsert(Collection pojo) {
        this.bind(pojo);
        return this.doInsert();
    }

    public MpaasQuery doExport(HttpServletResponse response, Class pojo) {
        return this.doExport(response, pojo, this.config.exportPageSize);
    }

    public MpaasQuery doExport(HttpServletResponse response, Class pojo, Integer pageSize) {
        if (!this.excelFileName.endsWith(".xlsx")) {
            this.excelFileName = this.excelFileName + ".xlsx";
        }
        response.setContentType("application/octet-stream");
        try {
            String f = new String(this.excelFileName.getBytes("UTF-8"), "ISO8859_1");
            response.setHeader("Content-Disposition", "attachment;filename=" + f);
            this.doExport((OutputStream)response.getOutputStream(), pojo, pageSize);
        }
        catch (Exception ex) {
            throw new MpaasRuntimeException(ex);
        }
        return this;
    }

    public MpaasQuery doExport(OutputStream os, Class pojo) {
        return this.doExport(os, pojo, this.config.exportPageSize);
    }

    public MpaasQuery doExport(OutputStream os, Class pojo, Integer pageSize) {
        this.bind(pojo);
        ExportExecutor exportExecutor = new ExportExecutor();
        exportExecutor.execute(this.buildQueryInfo());
        this.clear();
        return this;
    }

    public MpaasQuery orderBy(String field, String type) {
        this.orderby.add(new Parameter(field, type));
        return this;
    }

    public MpaasQuery groupBy(String field) {
        this.groupby = field;
        return this;
    }

    private void clear() {
        this.params.clear();
        this.updateField.clear();
        this.orderby.clear();
        this.clauses.clear();
        this.upper2Underline = null;
        this.clauseConjuction = "and";
        this.groupConIndex.clear();
        this.variables.clear();
        if (this.includeFields != null) {
            this.includeFields.clear();
        }
        if (this.excludeFields != null) {
            this.excludeFields.clear();
        }
        if (this.selectFields != null) {
            this.selectFields.clear();
        }
        this.updateFieldNames = null;
        this.viewQueryMode = false;
        this.viewName = null;
        this.viewConverted = false;
        this.clausePosition = 0;
        this.page = null;
        this.fullUpdate = true;
        this.pojoInfo = null;
        this.pojoClazz = null;
        this.sql = null;
        this.countSQL = null;
    }

    public MpaasQuery or() {
        this.clauseConjuction = "or";
        return this;
    }

    public MpaasQuery and() {
        this.clauseConjuction = "and";
        return this;
    }

    public MpaasQuery conjuctionAnd() {
        if (this.clauses.isEmpty()) {
            return this;
        }
        this.groupConIndex.add(new ConjunctionPosition(this.clausePosition, this.clauses.size(), "and"));
        return this;
    }

    public MpaasQuery groupBegin() {
        this.groupConIndex.add(new ConjunctionPosition(this.clausePosition, this.clauses.size(), "("));
        return this;
    }

    public MpaasQuery groupEnd() {
        this.groupConIndex.add(new ConjunctionPosition(this.clausePosition, this.clauses.size(), ")"));
        return this;
    }

    public MpaasQuery conjuctionOr() {
        if (this.clauses.isEmpty()) {
            return this;
        }
        this.groupConIndex.add(new ConjunctionPosition(this.clausePosition, this.clauses.size(), "or"));
        return this;
    }

    public MpaasQuery fileName(String excelFileName) {
        this.excelFileName = excelFileName;
        return this;
    }

    public Object decryptRowId(String content, Class clazz) {
        String s = MpaasQueryUtil.decryptRowId(content, this.getRowIdSecret());
        if (clazz == Integer.class) {
            return Integer.parseInt(s);
        }
        if (clazz == Long.class) {
            return Long.parseLong(s);
        }
        return s;
    }

    public MpaasQuery include(String ... fields) {
        if (this.includeFields == null) {
            this.includeFields = new HashSet<String>();
        }
        for (String s : Arrays.asList(fields)) {
            this.includeFields.add(s.toUpperCase());
        }
        return this;
    }

    public MpaasQuery exclude(String ... fields) {
        if (this.excludeFields == null) {
            this.excludeFields = new HashSet<String>();
        }
        for (String s : Arrays.asList(fields)) {
            this.excludeFields.add(s.toUpperCase());
        }
        return this;
    }

    public MpaasQuery select(String ... fields) {
        Set<String> sf = this.getSelectFields();
        for (String s : Arrays.asList(fields)) {
            sf.add(s);
        }
        return this;
    }

    public MpaasQuery unSelect(String ... fields) {
        Set<String> sf = this.getUnSelectFields();
        for (String s : Arrays.asList(fields)) {
            sf.add(s.toLowerCase());
        }
        return this;
    }

    public MpaasQuery unSelect(String s) {
        return this.unSelect(s.split(","));
    }

    public MpaasQuery select(String s) {
        return this.select(s.split(","));
    }

    private Set<String> getSelectFields() {
        if (this.selectFields == null) {
            this.selectFields = new HashSet<String>();
        }
        return this.selectFields;
    }

    private Set<String> getUnSelectFields() {
        if (this.unSelectFields == null) {
            this.unSelectFields = new HashSet<String>();
        }
        return this.unSelectFields;
    }

    public MpaasQuery like(String field, String value) {
        return this.addClause(field, "like", value);
    }

    public MpaasQuery likeNocase(String field, String value) {
        return this.addClause(field, "like no case", value);
    }

    public MpaasQuery notLike(String field, String value) {
        return this.addClause(field, "not like", value);
    }

    public MpaasQuery startWith(String field, String value) {
        return this.addClause(field, "^", value);
    }

    public MpaasQuery endWith(String field, String value) {
        return this.addClause(field, "$", value);
    }

    public MpaasQuery eq(String field, Object value) {
        return this.addClause(field, "=", value);
    }

    public MpaasQuery eqNocase(String field, Object value) {
        return this.addClause(field, "eq no case", value);
    }

    public MpaasQuery ne(String field, Object value) {
        return this.addClause(field, "!=", value);
    }

    public MpaasQuery lt(String field, Object value) {
        return this.addClause(field, "<", value);
    }

    public MpaasQuery gt(String field, Object value) {
        return this.addClause(field, ">", value);
    }

    public MpaasQuery lteq(String field, Object value) {
        return this.addClause(field, "<=", value);
    }

    public MpaasQuery gteq(String field, Object value) {
        return this.addClause(field, ">=", value);
    }

    public MpaasQuery isNull(String field) {
        return this.addClause(field, "is null", new Object[0]);
    }

    public MpaasQuery isNotNull(String field) {
        return this.addClause(field, "is not null", new Object[0]);
    }

    public MpaasQuery in(String field, Object ... values) {
        return this.addClause(field, "in", values);
    }

    public MpaasQuery in(String field, Collection values) {
        return this.addClause(field, "in", values.toArray());
    }

    public MpaasQuery notIn(String field, Object ... values) {
        return this.addClause(field, "not in", values);
    }

    public MpaasQuery notIn(String field, Collection values) {
        return this.addClause(field, "not in", values.toArray());
    }

    public MpaasQuery notNull(Object ... items) {
        if (items == null) {
            this.emptyResult = true;
        } else {
            for (Object item : items) {
                if (item == null) {
                    this.emptyResult = true;
                    break;
                }
                if (item instanceof String && MpaasUtil.strEmpty((String)item)) {
                    this.emptyResult = true;
                    break;
                }
                if (!(item instanceof Collection) || ((Collection)item).size() != 0) continue;
                this.emptyResult = true;
                break;
            }
        }
        return this;
    }

    public MpaasQuery distinct(String fields) {
        this.distinct = fields;
        return this;
    }

    public Object callFunction(String funName, Object ... paramAndResult) {
        List<Object> result = this.dbAdapter.executeProcedure("FUNCTION", funName, paramAndResult);
        if (result != null && result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    public List<Object> callProcedure(String procName, Object ... paramAndResult) {
        return this.dbAdapter.executeProcedure("PROCEDURE", procName, paramAndResult);
    }

    public void doMerge(Object item) {
        this.bind(item);
        PojoField idField = this.getPojoMetaInfo().getRowIdField();
        if (item instanceof BasePojo && ((BasePojo)item).pojoId() != null || idField != null && idField.getValue(item) != null) {
            this.doUpdate(item);
            return;
        }
        this.doInsert(item);
    }

    public MpaasQuery setVar(String name, Object value) {
        if (value == null) {
            throw new MpaasRuntimeException("variable %s is null", name);
        }
        Clause c = new Clause(name, value);
        c.setVariable("va_" + name);
        this.variables.add(c);
        return this;
    }

    private String[] getUpdateFieldNames() {
        if ((this.updateFieldNames == null || this.updateFieldNames.length == 0) && this.updateField != null && this.updateField.size() > 0) {
            this.updateFieldNames = new String[this.updateField.size()];
            for (int i = 0; i < this.updateFieldNames.length; ++i) {
                this.updateFieldNames[i] = this.updateField.get(i).getField();
            }
        }
        return this.updateFieldNames;
    }

    private boolean isBatchInsert() {
        return this.pojo != null && this.pojo instanceof Collection;
    }

    private QueryInfo buildQueryInfo() {
        QueryInfo info = new QueryInfo();
        info.setTable(this.table);
        info.setClauses(this.clauses);
        info.setRowId(this.rowid);
        info.setPojoClazz(this.pojoClazz);
        info.setPojo(this.pojo);
        info.setOrderby(this.orderby);
        info.setGroupby(this.groupby);
        info.setPage(this.page);
        info.setPageSize(this.pageSize);
        info.setGroupConIndex(this.groupConIndex);
        info.setPojoMeta(this.getPojoMetaInfo());
        info.setDistinct(this.distinct);
        info.setUpdateField(this.updateField);
        info.setSelectFields(this.selectFields);
        info.setUnSelectFields(this.unSelectFields);
        info.setIncludeFields(this.includeFields);
        info.setExcludeFields(this.excludeFields);
        info.setFullUpdate(this.fullUpdate);
        info.setRowIdSecret(this.getRowIdSecret());
        info.setDbAdapter(this.dbAdapter);
        info.setDialect(this.dialect);
        info.setParams(this.params);
        info.setVariables(this.variables);
        info.setViewQueryMode(this.viewQueryMode);
        info.setViewName(this.viewName);
        info.setViewConverted(this.viewConverted);
        info.setUpper2Underline(this.upper2Underline);
        info.setConfig(this.config);
        info.setSql(this.sql);
        info.setCountSQL(this.countSQL);
        info.setClauseConjuction(this.clauseConjuction);
        info.setExcelFileName(this.excelFileName);
        info.setRowVersion(this.rowVersion);
        info.setPojoInfo(this.pojoInfo);
        info.setUpdateFieldNames(this.getUpdateFieldNames());
        return info;
    }

    private String getRowIdSecret() {
        return this.config.rowIdSecret;
    }
}

