/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.conf;

import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.query.util.CryptoUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MpaasQueryConfig {
    @Value(value="${mpaas.query.dbvendor:}")
    public String DB_VENDOR;
    @Value(value="${mpaas.query.pagesize:20}")
    public Integer PAGE_SIZE;
    @Value(value="${mpaas.query.dbadatper:mybatis}")
    public String DB_ADAPTER;
    @Value(value="${mpaas.query.druidadmin:weblogic}")
    public String druidAdmin;
    @Value(value="${mpaas.query.druidpassword:weblogic1}")
    public String druidPassword;
    @Value(value="${spring.datasource.url:}")
    public String dbUrl;
    @Value(value="${spring.datasource.database:}")
    public String dbDatabase;
    @Value(value="${spring.datasource.username:}")
    public String dbUsername;
    @Value(value="${spring.datasource.password:}")
    public String dbPassword;
    @Value(value="${spring.datasource.driver-class-name:oracle.jdbc.driver.OracleDriver}")
    public String dbDriverClassName;
    @Value(value="${spring.datasource.initialSize:2}")
    public int dbInitialSize;
    @Value(value="${spring.datasource.filters:stat,wall}")
    public String dbFilters;
    @Value(value="${spring.datasource.jndi:none}")
    public String dbJndi;
    @Value(value="${mpaas.query.rowid.secret:JXU2Q0M5JXU1RERF}")
    public String rowIdSecret;
    @Value(value="${mpaas.query.security.mode:header}")
    public String securityMode;
    @Value(value="${mpaas.query.security.userHeaderName:uid}")
    public String userHeaderName;
    @Value(value="${mpaas.mode:PROD}")
    public String runMode;
    @Value(value="${mpaas.errorMessage:\u7cfb\u7edf\u51fa\u9519\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458}")
    public String humanMessage;
    @Value(value="${mpaas.security:false}")
    public boolean useSecurity;
    @Value(value="${mpaas.security.public:}")
    public String publicFilter;
    @Value(value="${mpaas.export.pagesize:200}")
    public Integer exportPageSize;

    public String getDBVendor() {
        if (MpaasUtil.strEmpty(this.DB_VENDOR)) {
            if (this.dbUrl != null && this.dbUrl.toLowerCase().contains("oracle")) {
                return "oracle";
            }
            return "mysql";
        }
        return this.DB_VENDOR;
    }

    public String getVariableFormat() {
        String fmt = ":%s";
        if ("mybatis".equalsIgnoreCase(this.DB_ADAPTER)) {
            fmt = "#{params.%s}";
        }
        return fmt;
    }

    public String getPassword() {
        if (this.dbPassword != null && this.dbPassword.startsWith("{AES}")) {
            return CryptoUtil.AESDncode(this.dbPassword.substring(5));
        }
        return this.dbPassword;
    }

    public boolean isSqlDatabase() {
        return !"nosql".equalsIgnoreCase(this.DB_ADAPTER);
    }
}

