/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.db;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.log.SWordLogger;
import com.definesys.mpaas.pojo.PojoCache;
import com.definesys.mpaas.pojo.PojoField;
import com.definesys.mpaas.pojo.PojoMeta;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.db.DatabaseAdapter;
import com.definesys.mpaas.query.db.DatabaseAdapterFactory;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.db.StorageDatasource;
import com.definesys.mpaas.query.lookup.LookupHandler;
import com.definesys.mpaas.query.model.QueryInfo;
import com.definesys.mpaas.query.oracle.ProcedureExecutor;
import com.definesys.mpaas.query.util.ContextWrapper;
import com.definesys.mpaas.query.util.TypeUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class DefaultDatabaseAdapter
implements DatabaseAdapter {
    @Autowired
    protected MpaasQueryConfig config;
    @Autowired(required=false)
    private DataSource dataSource;

    @Override
    public List<Object> executeProcedure(String funOrProc, String name, Object[] paramAndResult) {
        if (!"oracle".equalsIgnoreCase(this.config.getDBVendor())) {
            throw new UnsupportedOperationException("procedure only oracle database support");
        }
        List<Object> result = null;
        try {
            Connection connection = this.dataSource.getConnection();
            ProcedureExecutor executor = new ProcedureExecutor(connection);
            result = executor.call(funOrProc, name, paramAndResult);
            executor.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new MpaasRuntimeException("executeProcedure error:" + e.getMessage());
        }
        return result;
    }

    @Override
    public List<Object> executeBatchInsert(QueryInfo queryInfo, String sql, List<List<Parameter>> paramsList, String ... keyColumns) {
        if (this.isSqlDatabase().booleanValue()) {
            DatabaseAdapterFactory factory = ContextWrapper.getAdapterFactory();
            DatabaseAdapter sql2o = factory.buildDatabaseAdapter("sql2o");
            return sql2o.executeBatchInsert(queryInfo, sql, paramsList, keyColumns);
        }
        return null;
    }

    @Override
    public void dataSource(StorageDatasource dataSource) {
    }

    @Override
    public Boolean isSqlDatabase() {
        return this.config.isSqlDatabase();
    }

    @Override
    public String varformat() {
        return this.config.getVariableFormat();
    }

    @Override
    public DatabaseAdapter createInstance(MpaasQueryConfig config, SWordLogger logger) {
        throw new MpaasRuntimeException("createInstance no implement");
    }

    protected <T> List<T> basicTypeHandle(List<Map<String, Object>> data, Class<T> clazz) {
        ArrayList result = new ArrayList();
        try {
            for (Map<String, Object> row : data) {
                String c;
                Object v;
                Iterator<String> iterator = row.keySet().iterator();
                if (!iterator.hasNext() || (v = row.get(c = iterator.next())) == null) continue;
                Object r = Class.forName(clazz.getName()).getConstructor(Class.forName("java.lang.String")).newInstance(v.toString());
                result.add(r);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new MpaasRuntimeException(ex);
        }
        return result;
    }

    protected <T> List<T> pojoTypeHandle(List<Map<String, Object>> data, Class<T> clazz) {
        ArrayList<Object> result = new ArrayList<Object>();
        PojoMeta meta = (PojoMeta)PojoCache.cache().get(clazz.getName(), clazz);
        for (Map<String, Object> row : data) {
            Object r = null;
            try {
                r = Class.forName(clazz.getName()).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MpaasRuntimeException(e);
            }
            for (String c : row.keySet()) {
                PojoField field = meta.findPojoField(c);
                if (field == null) continue;
                field.setValue(r, TypeUtil.convert(row.get(c), field.getField().getType()));
            }
            result.add(r);
        }
        return result;
    }

    protected <T> List<T> lookupHandle(QueryInfo info, List<T> data) {
        LookupHandler<T> handler = new LookupHandler<T>(info.getPojoMeta(), data, info.getDbAdapter());
        handler.execute();
        return data;
    }
}

