/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.drill;

import com.definesys.mpaas.pojo.PojoField;
import com.definesys.mpaas.pojo.PojoMeta;
import com.definesys.mpaas.query.MpaasQuery;
import com.definesys.mpaas.query.annotation.Link;
import com.definesys.mpaas.query.drill.Driller;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;

public class QueryDrill
extends Driller {
    public QueryDrill(MpaasQuery query, PojoMeta meta, Collection data) {
        super(query, meta, data);
    }

    public QueryDrill(MpaasQuery query, PojoMeta meta, Object data) {
        super(query, meta, data);
    }

    @Override
    public void drill() {
        List<PojoField> fields = this.getLinkField();
        for (PojoField f : fields) {
            Link link = f.getLink();
            for (Object item : this.data) {
                this.drill(f, link, item);
            }
        }
    }

    private void drill(PojoField field, Link link, Object item) {
        Object value = this.meta.findPojoField(link.from()).getValue(item);
        if (value == null) {
            return;
        }
        List rows = this.query.eq(link.to(), value).doQuery(this.getType(field));
        if (rows == null || rows.size() == 0) {
            return;
        }
        if (this.isCollectionType(field)) {
            field.setValue(item, rows);
        } else {
            field.setValue(item, rows.get(0));
        }
    }

    private Class getType(PojoField field) {
        Type t;
        Class clazz = field.getField().getType();
        if (clazz == List.class && (t = field.getField().getGenericType()) instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)t).getActualTypeArguments()[0];
        }
        return clazz;
    }

    private boolean isCollectionType(PojoField field) {
        Class<?> clazz = field.getField().getType();
        if (clazz == List.class) {
            // empty if block
        }
        return false;
    }
}

