/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.excel;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.pojo.PojoField;
import com.definesys.mpaas.pojo.PojoMeta;
import com.definesys.mpaas.query.annotation.Style;
import com.definesys.mpaas.query.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.dhatim.fastexcel.Workbook;
import org.dhatim.fastexcel.Worksheet;

public class MpaasExcel<T> {
    private Workbook wb;
    private Worksheet ws;
    private PojoMeta pojo;
    private boolean titleExported = false;
    private Set<String> exclude;
    private Set<String> include;

    public MpaasExcel(OutputStream os, PojoMeta pojo, Set<String> include, Set<String> exclude) {
        this.wb = new Workbook(os, "MpassExcelExport");
        this.ws = this.wb.newWorksheet("Sheet 1");
        this.pojo = pojo;
        this.exclude = exclude;
        this.include = include;
    }

    public void export(List<Object> data) {
        if (!this.titleExported) {
            this.titleExported = true;
            this.exportTitle();
        }
        for (int i = 0; i < data.size(); ++i) {
            Object item = data.get(i);
            List<PojoField> fields = this.pojo.getPojoFields();
            int c = 0;
            for (PojoField f : fields) {
                if (!this.isCanExport(f)) continue;
                Object value = f.getFormatValue(item);
                if (value instanceof String) {
                    value = StringUtils.encodeHtml((String)value);
                }
                this.ws.value(i, c++, value);
            }
        }
        try {
            this.ws.flush();
        }
        catch (IOException e) {
            throw new MpaasRuntimeException(e);
        }
    }

    public void finish() {
        try {
            if (!this.titleExported) {
                this.titleExported = true;
                this.export(new ArrayList<Object>());
            }
            this.wb.finish();
        }
        catch (IOException e) {
            throw new MpaasRuntimeException(e);
        }
    }

    private void exportTitle() {
        int i = 0;
        for (PojoField f : this.pojo.getPojoFields()) {
            String w;
            if (!this.isCanExport(f)) continue;
            this.ws.style(0, i).bold().set();
            this.ws.value(0, i, f.getDisplayName());
            Style s = f.getStyle();
            if (s != null && (w = s.width()) != null && w.trim().length() > 0) {
                try {
                    Double dw = Double.parseDouble(w);
                    this.ws.width(i, dw);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        try {
            this.ws.flush();
        }
        catch (IOException e) {
            throw new MpaasRuntimeException(e);
        }
    }

    private boolean isCanExport(PojoField field) {
        boolean ok = true;
        String name = field.getField().getName().toUpperCase();
        String dbName = field.getSqlColumnName(this.pojo.getUpper2Underline()).toUpperCase();
        if (this.exclude != null && (this.exclude.contains(name) || this.exclude.contains(dbName))) {
            ok = false;
        }
        if (this.include != null) {
            ok = this.include.contains(name) || this.include.contains(dbName);
        }
        return ok;
    }
}

