/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.executor;

import com.definesys.mpaas.pojo.PojoMeta;
import com.definesys.mpaas.query.db.Clause;
import com.definesys.mpaas.query.db.ClauseSQL;
import com.definesys.mpaas.query.db.ConjunctionPosition;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.executor.ExecuteResult;
import com.definesys.mpaas.query.executor.Executor;
import com.definesys.mpaas.query.model.QueryInfo;
import java.util.ArrayList;
import java.util.List;

public abstract class DefaultExecutor
implements Executor {
    protected QueryInfo queryInfo;
    protected String sql;
    protected List<Parameter> params;

    @Override
    public ExecuteResult execute(QueryInfo info) {
        this.init(info);
        return null;
    }

    protected void init(QueryInfo info) {
        this.queryInfo = info;
        this.params = info.getParams();
        this.sql = info.getSql();
    }

    protected List<Parameter> buildParameter() {
        if (this.params.size() == 0) {
            this.buildWhereClause();
        }
        ArrayList<Parameter> result = null;
        for (Clause c : this.queryInfo.getVariables()) {
            if (result == null) {
                result = new ArrayList<Parameter>();
            }
            result.add(new Parameter(c.getVariable(), c.getValue()));
        }
        if (result == null) {
            return this.params;
        }
        result.addAll(this.params);
        return result;
    }

    protected String buildWhereClause() {
        return this.buildWhereClause(true);
    }

    protected String buildWhereClause(boolean appendOrder) {
        StringBuffer sb = new StringBuffer();
        PojoMeta pm = this.queryInfo.getPojoMeta();
        for (int i = 0; i < this.queryInfo.getClauses().size(); ++i) {
            Clause c = this.queryInfo.getClauses().get(i);
            if (pm != null) {
                c.setField(pm.getFieldDBName(c.getField()));
            } else {
                c.setField(c.getField());
            }
            c.setVariableFormat(this.getVariableFormat());
            ClauseSQL cs = this.queryInfo.getDialect().handleClause(c);
            if (ClauseSQL.NONE.equals(cs.getType())) continue;
            if (ClauseSQL.VARIABLE.equals(cs.getType())) {
                this.params.add(new Parameter(c.getVariable(), c.getValue()));
            }
            String sql = cs.getSqlClause();
            if (sb.length() == 0) {
                sb.append("where (");
            }
            sb.append(this.calculateConjunction(c.getPosition()));
            if (i > 0) {
                sb.append(" " + c.getConjunction() + " ");
            }
            sb.append(sql);
        }
        if (sb.length() > 0) {
            sb.append(")");
        }
        sb = new StringBuffer(this.buildWhereClausePost(sb.toString()));
        String groupby = this.queryInfo.getGroupby();
        if (groupby != null) {
            sb.append(" group by " + groupby + " ");
        }
        boolean flag = true;
        if (appendOrder) {
            for (Parameter p : this.queryInfo.getOrderby()) {
                if (flag) {
                    sb.append(" order by ");
                } else {
                    sb.append(",");
                }
                flag = false;
                if (pm != null) {
                    sb.append(String.format("%s %s", pm.getFieldDBName(p.getName()), p.getValue()));
                    continue;
                }
                sb.append(String.format("%s %s", p.getName(), p.getValue()));
            }
        }
        return sb.toString();
    }

    private String calculateConjunction(Integer position) {
        String result = "";
        List<ConjunctionPosition> groupConIndex = this.queryInfo.getGroupConIndex();
        for (int i = 0; i < groupConIndex.size(); ++i) {
            ConjunctionPosition p = groupConIndex.get(i);
            if (p.getPos() != position.intValue() || p.isHit() || !p.isConjunction()) continue;
            if (p.getPos() > position) break;
            p.setHit(true);
            result = ")" + p.getConjunction() + "(";
        }
        boolean hit = false;
        for (int i = 0; i < groupConIndex.size(); ++i) {
            ConjunctionPosition p = groupConIndex.get(i);
            if (p.getPos() != position.intValue() || p.isHit() || p.isConjunction()) {
                if (!"LEFT".equals(p.getType())) continue;
                hit = p.isHit();
                continue;
            }
            if (p.getPos() > position) break;
            p.setHit(true);
            if ("LEFT".equals(p.getType())) {
                result = result + "(";
                continue;
            }
            if (!hit) continue;
            result = ")" + result;
        }
        return result;
    }

    private String buildWhereClausePost(String sql) {
        String v = sql.replaceAll("\\(\\s+or\\s+", "(");
        v = v.replaceAll("\\(\\s+and\\s+", "(");
        v = v.replaceAll("\\(\\s*\\)", " ");
        v = v.replaceAll("^where\\s*or", "where ");
        v = v.replaceAll("^where\\s*and", "where ");
        if (!this.isEnd()) {
            v = v + ")";
        }
        return v;
    }

    protected String getVariableFormat() {
        return this.queryInfo.getDbAdapter().varformat();
    }

    private boolean isEnd() {
        List<ConjunctionPosition> groupConIndex = this.queryInfo.getGroupConIndex();
        if (groupConIndex.size() == 0) {
            return true;
        }
        ConjunctionPosition con = groupConIndex.get(groupConIndex.size() - 1);
        if ("RIGHT".equals(con.getType()) && !con.isHit()) {
            for (int i = groupConIndex.size() - 1; i >= 0; --i) {
                ConjunctionPosition c = groupConIndex.get(i);
                if (!"LEFT".equals(c.getType()) || !c.isHit()) continue;
                return false;
            }
        }
        return true;
    }
}

