/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.executor;

import com.definesys.mpaas.query.db.ConjunctionPosition;
import com.definesys.mpaas.query.db.PageQueryResult;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.executor.ExecuteResult;
import com.definesys.mpaas.query.executor.QueryExecutor;
import com.definesys.mpaas.query.model.QueryInfo;
import java.util.List;
import java.util.Map;

public class PageQueryExecutor<T>
extends QueryExecutor {
    @Override
    public ExecuteResult execute(QueryInfo info) {
        this.init(info);
        ExecuteResult<T> result = null;
        result = info.getPojoClazz() == null ? this.doPageQuery(info.getPage(), info.getPageSize(), info.getPojoClazz()) : this.doPageQuery(info.getPage(), info.getPageSize());
        return result;
    }

    public ExecuteResult<T> doPageQuery(Integer page, Integer pageSize) {
        if (this.queryInfo.getPojoClazz() != null) {
            return this.doPageQuery(page, pageSize, this.queryInfo.getPojoClazz());
        }
        String query = this.buildQuerySql(page, pageSize);
        PageQueryResult<Map<String, Object>> pageQueryResult = new PageQueryResult<Map<String, Object>>();
        pageQueryResult.setResult(this.queryInfo.getDbAdapter().executeQueryAsList(this.queryInfo, query, this.buildParameter()));
        this.params.clear();
        for (ConjunctionPosition p : this.queryInfo.getGroupConIndex()) {
            p.setHit(false);
        }
        String sql = this.buildCountSql();
        this.queryInfo.setTag("count");
        List<Long> count = this.queryInfo.getDbAdapter().executeQuery(this.queryInfo, sql, this.buildParameter(), Long.class);
        if (count != null && count.size() > 0) {
            pageQueryResult.setCount(count.get(0));
        }
        this.queryInfo.setTag(null);
        return this.drill(null, pageQueryResult);
    }

    public ExecuteResult<T> doPageQuery(Integer page, Integer pageSize, Class<T> result) {
        String query = null;
        List<Parameter> parameters = null;
        Boolean isSqlDatabase = this.queryInfo.isSqlDb();
        if (isSqlDatabase.booleanValue()) {
            query = this.buildQuerySql(page, pageSize);
            parameters = this.buildParameter();
        }
        PageQueryResult<Map<String, Object>> pageQueryResult = new PageQueryResult<Map<String, Object>>();
        if (result == null) {
            pageQueryResult.setResult(this.postQuery(this.queryInfo.getDbAdapter().executeQueryAsList(this.queryInfo, query, parameters)));
        } else {
            pageQueryResult.setResult(this.postQuery(this.queryInfo.getDbAdapter().executeQuery(this.queryInfo, query, parameters, result)));
        }
        this.params.clear();
        for (ConjunctionPosition p : this.queryInfo.getGroupConIndex()) {
            p.setHit(false);
        }
        String cntSql = null;
        if (isSqlDatabase.booleanValue()) {
            cntSql = this.buildCountSql();
            parameters = this.buildParameter();
        }
        this.queryInfo.setTag("count");
        List<Long> count = this.queryInfo.getDbAdapter().executeQuery(this.queryInfo, cntSql, parameters, Long.class);
        if (count != null && count.size() > 0) {
            pageQueryResult.setCount(count.get(0));
        }
        this.queryInfo.setTag(null);
        return this.drill(null, pageQueryResult);
    }
}

