/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.executor;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.pojo.PojoField;
import com.definesys.mpaas.pojo.PojoMeta;
import com.definesys.mpaas.query.db.Clause;
import com.definesys.mpaas.query.db.PageQueryResult;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.drill.QueryDrill;
import com.definesys.mpaas.query.executor.DefaultExecutor;
import com.definesys.mpaas.query.executor.ExecuteResult;
import com.definesys.mpaas.query.model.MpaasBasePojo;
import com.definesys.mpaas.query.model.QueryInfo;
import com.definesys.mpaas.query.util.SQLUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.Assert;

public class QueryExecutor<T>
extends DefaultExecutor {
    private boolean viewConverted = false;

    @Override
    public ExecuteResult<T> execute(QueryInfo info) {
        this.init(info);
        ExecuteResult<T> result = null;
        result = info.getPojoClazz() == null ? this.doQueryAsList() : this.doQuery();
        return result;
    }

    public ExecuteResult<T> doQuery() {
        String query = null;
        List<Parameter> parameters = null;
        if (this.queryInfo.isSqlDb().booleanValue()) {
            query = this.buildQuerySql(this.queryInfo.getPage(), this.queryInfo.getPageSize());
            parameters = this.buildParameter();
        }
        List rs = this.postQuery(this.queryInfo.getDbAdapter().executeQuery(this.queryInfo, query, parameters, this.queryInfo.getPojoClazz()));
        return this.drill(rs, null);
    }

    public ExecuteResult<T> doQueryAsList() {
        String query = null;
        List<Parameter> parameters = null;
        if (this.queryInfo.isSqlDb().booleanValue()) {
            query = this.buildQuerySql(this.queryInfo.getPage(), this.queryInfo.getPageSize());
            parameters = this.buildParameter();
        }
        List<Map<String, Object>> rs = this.queryInfo.getDbAdapter().executeQueryAsList(this.queryInfo, query, parameters);
        return this.drill(rs, null);
    }

    protected ExecuteResult<T> drill(List<T> data, PageQueryResult<T> pageResult) {
        QueryDrill drill = new QueryDrill(this.queryInfo.getInstance(), this.queryInfo.getPojoMeta(), data);
        drill.drill();
        ExecuteResult<T> result = new ExecuteResult<T>();
        result.setPageQueryResult(pageResult);
        result.setTable(data);
        return result;
    }

    protected <T> List<T> postQuery(List<T> result) {
        if (result == null) {
            return result;
        }
        for (T item : result) {
            if (!(item instanceof MpaasBasePojo)) continue;
            ((MpaasBasePojo)item).encryptRowId(this.getRowIdSecret());
        }
        return result;
    }

    private String getRowIdSecret() {
        return this.queryInfo.getConfig().rowIdSecret;
    }

    protected String buildQuerySql(Integer page, Integer pageSize) {
        this.sql = this.buildSelectSql();
        String s = this.sql + " " + this.buildWhereClause();
        if (page == null || pageSize == null) {
            return s;
        }
        return this.queryInfo.getDialect().buildPageQuery(s, page, pageSize);
    }

    private String buildSelectSql() {
        if (MpaasUtil.strEmpty(this.sql)) {
            this.sql = this.buildSqlBySelectFields();
            if (MpaasUtil.strEmpty(this.sql) && this.queryInfo.isViewQueryMode()) {
                Assert.notNull((Object)this.queryInfo.getViewName(), (String)"view name is null");
                this.sql = this.queryInfo.getPojoMeta().getSqlQuerys().get(this.queryInfo.getViewName()).sql();
                return this.sql;
            }
        }
        Assert.notNull((Object)this.sql, (String)"sql is null");
        this.sql = this.viewQuerySQLConvert(this.sql);
        this.sql = this.variableSQLConvert(this.sql);
        return this.sql;
    }

    private String viewQuerySQLConvert(String sql) {
        PojoMeta pm = this.queryInfo.getPojoMeta();
        boolean viewQueryMode = this.queryInfo.isViewQueryMode();
        if (viewQueryMode && !this.viewConverted) {
            sql = SQLUtil.replaceWithQuerySQL(sql, pm.getSqlQuerys());
            this.viewConverted = true;
        }
        return sql;
    }

    private String variableSQLConvert(String sql) {
        for (Clause c : this.queryInfo.getVariables()) {
            String s = String.format(this.getVariableFormat(), c.getVariable());
            sql = sql.replaceAll("#" + c.getField(), s);
            sql = sql.replaceAll(String.format("#\\{%s\\}", c.getField()), (String)c.getValue());
        }
        return sql;
    }

    private String buildSqlBySelectFields() {
        if (this.buildFinalSelectFields().size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer("select ");
        PojoMeta pm = this.queryInfo.getPojoMeta();
        Assert.notNull((Object)this.queryInfo.getTable(), (String)"table name is null");
        boolean flag = false;
        for (String s : this.queryInfo.getSelectFields()) {
            if (flag) {
                sb.append(",");
            }
            flag = true;
            if ("*".equals(s)) {
                sb.append(s);
                continue;
            }
            sb.append(pm == null ? s : pm.getFieldDBName(s));
        }
        sb.append(" from");
        sb.append(" " + (this.queryInfo.isViewQueryMode() ? this.queryInfo.getViewName() : this.queryInfo.getTable()));
        return sb.toString();
    }

    private Set<String> buildFinalSelectFields() {
        Set<String> sf = this.queryInfo.getSelectFields();
        PojoMeta pm = this.queryInfo.getPojoMeta();
        if (sf.isEmpty()) {
            if (!this.queryInfo.isViewQueryMode() && pm != null) {
                for (PojoField f : pm.getDatabaseFields()) {
                    sf.add(f.getSqlColumnName(this.queryInfo.getUpper2Underline()));
                }
            } else {
                sf.add("*");
            }
        }
        if (!this.queryInfo.isViewQueryMode()) {
            for (String s : this.queryInfo.getUnSelectFields()) {
                PojoField f = pm.findPojoField(s);
                if (f == null) {
                    throw new MpaasRuntimeException("can not find field %s", s);
                }
                Iterator<String> iterator = sf.iterator();
                while (iterator.hasNext()) {
                    if (!f.getSqlColumnName(this.queryInfo.getUpper2Underline()).equalsIgnoreCase(iterator.next())) continue;
                    iterator.remove();
                }
            }
        }
        return sf;
    }

    protected String buildCountSql() {
        String s;
        if (this.queryInfo.getCountSQL() == null) {
            this.sql = this.buildSelectSql();
            s = this.sql + " " + this.buildWhereClause(false);
        } else {
            s = this.queryInfo.getCountSQL() + " " + this.buildWhereClause(false);
        }
        s = String.format("select count(1)l from(%s)y", s);
        return s;
    }
}

