/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.executor;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.pojo.PojoField;
import com.definesys.mpaas.pojo.PojoMeta;
import com.definesys.mpaas.query.MpaasQuery;
import com.definesys.mpaas.query.annotation.SystemColumnType;
import com.definesys.mpaas.query.db.Clause;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.executor.DefaultExecutor;
import com.definesys.mpaas.query.executor.ExecuteResult;
import com.definesys.mpaas.query.model.BasePojo;
import com.definesys.mpaas.query.model.QueryInfo;
import com.definesys.mpaas.query.session.MpaasSession;
import com.definesys.mpaas.query.util.MpaasQueryUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UpdateExecutor
extends DefaultExecutor {
    private MpaasQuery instance;

    public UpdateExecutor(MpaasQuery instance) {
        this.instance = instance;
    }

    @Override
    public ExecuteResult execute(QueryInfo info) {
        super.execute(info);
        boolean valid = false;
        Object pojo = info.getPojo();
        PojoMeta pm = this.queryInfo.getPojoMeta();
        if (this.queryInfo.getClauses().size() == 0) {
            if (pojo != null) {
                PojoField idField = pm.getRowIdField();
                if (pojo instanceof BasePojo && ((BasePojo)pojo).pojoId() != null) {
                    this.rowid(idField.getField().getName(), (String)((BasePojo)pojo).pojoId(), true);
                    valid = true;
                }
                Iterator<Clause> value = idField.getValue(pojo);
                if (!valid && idField != null && value != null) {
                    this.queryInfo.getClauses().add(new Clause(idField.getFieldName(), "=", "and", value));
                    valid = true;
                }
            }
            if (!valid) {
                throw MpaasRuntimeException.fromCode("SW-180227", new Object[0]);
            }
        }
        if (pojo != null) {
            List<Clause> cls = this.updateActionInit(pojo, this.queryInfo.getUpdateFieldNames());
            this.queryInfo.getUpdateField().clear();
            for (Clause c : cls) {
                this.update(c);
            }
        }
        String query = null;
        List<Parameter> parameters = null;
        if (info.getDbAdapter().isSqlDatabase().booleanValue()) {
            query = this.buildUpdateSql();
            parameters = this.buildParameter();
        }
        info.getDbAdapter().executeUpdate(info, query, parameters);
        return null;
    }

    private void update(Clause clause) {
        if (clause.getTag() != null) {
            this.update(clause.getField(), null, clause.getTag());
        } else {
            this.update(clause.getField(), clause.getValue(), null);
        }
    }

    private void update(String field, Object value, Object tag) {
        int index = 0;
        Clause clause = new Clause(field, value);
        clause.setTag(tag);
        for (Clause c : this.queryInfo.getUpdateField()) {
            if (c.getField() == null || !c.getField().equals(clause.getField())) continue;
            ++index;
        }
        if (index > 0) {
            clause.setVariable(clause.getVariable() + "_" + index);
        }
        this.queryInfo.getUpdateField().add(clause);
    }

    private String buildUpdateSql() {
        if (MpaasUtil.strEmpty(this.queryInfo.getTable())) {
            throw MpaasRuntimeException.fromCode("SW-180226", new Object[0]);
        }
        return String.format("update %s %s %s", this.queryInfo.getTable(), this.buildUpdateSetClause(), this.buildWhereClause());
    }

    private String buildUpdateSetClause() {
        StringBuffer sb = new StringBuffer();
        String varFormat = this.getVariableFormat();
        for (Clause c : this.queryInfo.getUpdateField()) {
            if (sb.length() > 0) {
                sb.append(",");
            } else {
                sb.append("set ");
            }
            if (c.getTag() == null) {
                this.params.add(new Parameter(c.getVariable(), c.getValue()));
                sb.append(String.format("%s=" + varFormat, c.getField(), c.getVariable()));
                continue;
            }
            sb.append(c.getTag().toString());
        }
        return sb.toString();
    }

    public List<Clause> updateActionInit(Object pojo, String[] fields) {
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        PojoMeta pm = this.queryInfo.getPojoMeta();
        List<PojoField> updateFields = pm.getPojoFields();
        if (fields != null && fields.length > 0) {
            updateFields = new ArrayList<PojoField>();
            for (String v : fields) {
                PojoField f = pm.findPojoField(v);
                if (f == null) {
                    throw new MpaasRuntimeException("field:" + v + " not found");
                }
                updateFields.add(f);
            }
        }
        try {
            for (PojoField f : updateFields) {
                if (f.isKeyField().booleanValue() || !f.isDBColumn().booleanValue()) continue;
                SystemColumnType st = f.getSystemColumnType();
                String columnName = f.getSqlColumnName(this.queryInfo.getUpper2Underline());
                if (st != null) continue;
                Object value = f.getValue(pojo);
                if (value == null) {
                    Clause c = new Clause(columnName, null);
                    c.setTag(String.format("%s = null", columnName));
                    clauses.add(c);
                    continue;
                }
                clauses.add(new Clause(columnName, value));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        clauses.addAll(this.updateSystemField(pojo));
        return clauses;
    }

    private List<Clause> updateSystemField(Object pojo) {
        String user = MpaasSession.getCurrentUser();
        PojoMeta pm = this.queryInfo.getPojoMeta();
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        for (PojoField f : pm.getPojoFields()) {
            Method setMethod;
            SystemColumnType st = f.getSystemColumnType();
            String columnName = f.getSqlColumnName(this.queryInfo.getUpper2Underline());
            if (st == null || (setMethod = f.setter()) == null) continue;
            try {
                if (SystemColumnType.LASTUPDATE_BY == st) {
                    setMethod.invoke(pojo, user);
                    clauses.add(new Clause(columnName, user));
                    continue;
                }
                if (SystemColumnType.LASTUPDATE_ON == st) {
                    setMethod.invoke(pojo, MpaasQueryUtil.currentDate());
                    clauses.add(new Clause(columnName, MpaasQueryUtil.currentDate()));
                    continue;
                }
                if (SystemColumnType.OBJECT_VERSION != st) continue;
                Clause c = new Clause(columnName, null);
                c.setTag(String.format("%s = %s+1", columnName, columnName));
                clauses.add(c);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return clauses;
    }

    public void rowid(String field, String rowid, boolean decrypt) {
        this.queryInfo.setRowId(rowid);
        if (decrypt) {
            this.queryInfo.getClauses().add(new Clause(field, "=", "and", this.decryptRowId(rowid, String.class)));
        } else {
            this.queryInfo.getClauses().add(new Clause(field, "=", "and", rowid));
        }
    }

    public Object decryptRowId(String content, Class clazz) {
        String s = MpaasQueryUtil.decryptRowId(content, this.queryInfo.getRowIdSecret());
        if (clazz == Integer.class) {
            return Integer.parseInt(s);
        }
        if (clazz == Long.class) {
            return Long.parseLong(s);
        }
        return s;
    }
}

