/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.model;

import com.definesys.mpaas.query.annotation.Column;
import com.definesys.mpaas.query.annotation.ColumnType;
import com.definesys.mpaas.query.annotation.RowID;
import com.definesys.mpaas.query.model.BasePojo;
import com.definesys.mpaas.query.util.ContextWrapper;
import com.definesys.mpaas.query.util.MpaasQueryUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public abstract class MpaasBasePojo
implements BasePojo {
    @Column(type=ColumnType.JAVA)
    private String rowId;

    public String getRowId() {
        if (this.rowId == null) {
            this.encryptRowId();
        }
        return this.rowId;
    }

    public void setRowId(String value) {
        this.rowId = value;
    }

    public String encryptRowId() {
        return this.encryptRowId(ContextWrapper.getMpassConfig().rowIdSecret);
    }

    public String encryptRowId(String secret) {
        if (this.rowId == null) {
            Field[] fields;
            Class<?> clazz = this.getClass();
            for (Field f : fields = clazz.getDeclaredFields()) {
                if (f.getAnnotation(RowID.class) == null) continue;
                String name = f.getName();
                try {
                    Method m = clazz.getMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
                    Object value = m.invoke((Object)this, new Object[0]);
                    this.setRowId(MpaasQueryUtil.encryptRowId(value, secret));
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.rowId;
    }

    public static String id(String value, String secret) {
        return MpaasQueryUtil.decryptRowId(value, secret);
    }

    @Override
    public Object pojoId() {
        return this.getRowId();
    }
}

