/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.sql2o.ResultSetHandler;
import org.sql2o.ResultSetHandlerFactory;
import org.sql2o.Sql2oException;
import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;
import org.sql2o.quirks.Quirks;
import org.sql2o.reflection.Getter;
import org.sql2o.reflection.Pojo;
import org.sql2o.reflection.PojoMetadata;
import org.sql2o.reflection.Setter;
import org.sql2o.tools.AbstractCache;

public class DefaultResultSetHandlerFactory<T>
implements ResultSetHandlerFactory<T> {
    private final PojoMetadata metadata;
    private final Quirks quirks;
    private static final AbstractCache<Key, ResultSetHandler, ResultSetMetaData> c = new AbstractCache<Key, ResultSetHandler, ResultSetMetaData>(){

        @Override
        protected ResultSetHandler evaluate(Key key, ResultSetMetaData param) {
            try {
                return key.factory().newResultSetHandler0(param);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public DefaultResultSetHandlerFactory(PojoMetadata pojoMetadata, Quirks quirks) {
        this.metadata = pojoMetadata;
        this.quirks = quirks;
    }

    private static Getter getGetter(final Quirks quirks, final String propertyPath, final PojoMetadata metadata) {
        int index = propertyPath.indexOf(46);
        if (index <= 0) {
            final Getter getter = metadata.getPropertyGetterIfExists(propertyPath);
            if (getter == null) {
                return null;
            }
            final Converter converter = quirks.converterOf(getter.getType());
            if (converter == null) {
                return getter;
            }
            return new Getter(){

                @Override
                public Object getProperty(Object obj) {
                    try {
                        return converter.convert(getter.getProperty(obj));
                    }
                    catch (ConverterException e) {
                        throw new Sql2oException("Error trying to convert column " + propertyPath + " to type " + getter.getType(), e);
                    }
                }

                @Override
                public Class getType() {
                    return getter.getType();
                }
            };
        }
        return new Getter(){

            @Override
            public Object getProperty(Object obj) {
                Pojo pojo = new Pojo(metadata, metadata.isCaseSensitive(), obj);
                return pojo.getProperty(propertyPath, quirks);
            }

            @Override
            public Class getType() {
                return Object.class;
            }
        };
    }

    private static Setter getSetter(final Quirks quirks, final String propertyPath, final PojoMetadata metadata) {
        int index = propertyPath.indexOf(46);
        if (index <= 0) {
            final Setter setter = metadata.getPropertySetterIfExists(propertyPath);
            if (setter == null) {
                return null;
            }
            final Converter converter = quirks.converterOf(setter.getType());
            if (converter == null) {
                return setter;
            }
            return new Setter(){

                @Override
                public void setProperty(Object obj, Object value) {
                    try {
                        setter.setProperty(obj, converter.convert(value));
                    }
                    catch (ConverterException e) {
                        throw new Sql2oException("Error trying to convert column " + propertyPath + " to type " + setter.getType(), e);
                    }
                }

                @Override
                public Class getType() {
                    return setter.getType();
                }
            };
        }
        return new Setter(){

            @Override
            public void setProperty(Object obj, Object value) {
                Pojo pojo = new Pojo(metadata, metadata.isCaseSensitive(), obj);
                pojo.setProperty(propertyPath, value, quirks);
            }

            @Override
            public Class getType() {
                return Object.class;
            }
        };
    }

    @Override
    public ResultSetHandler<T> newResultSetHandler(ResultSetMetaData meta) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            stringBuilder.append(this.quirks.getColumnName(meta, i)).append("\n");
        }
        return c.get(new Key(stringBuilder.toString(), this), meta);
    }

    private ResultSetHandler<T> newResultSetHandler0(ResultSetMetaData meta) throws SQLException {
        String colName;
        int i;
        final Converter converter = this.quirks.converterOf(this.metadata.getType());
        final int columnCount = meta.getColumnCount();
        Getter[] getters = new Getter[columnCount + 1];
        for (i = 1; i <= columnCount; ++i) {
            colName = this.quirks.getColumnName(meta, i);
            getters[i] = DefaultResultSetHandlerFactory.getGetter(this.quirks, colName, this.metadata);
            if (getters[i] != null) continue;
            getters[i] = DefaultResultSetHandlerFactory.getGetter(this.quirks, colName.replaceAll("_", ""), this.metadata);
        }
        final Setter[] setters = new Setter[columnCount + 1];
        for (i = 1; i <= columnCount; ++i) {
            colName = this.quirks.getColumnName(meta, i);
            setters[i] = DefaultResultSetHandlerFactory.getSetter(this.quirks, colName, this.metadata);
            if (setters[i] != null) continue;
            setters[i] = DefaultResultSetHandlerFactory.getSetter(this.quirks, colName.replaceAll("_", ""), this.metadata);
        }
        final boolean useExecuteScalar = converter != null && columnCount == 1 && setters[1] == null;
        return new ResultSetHandler<T>(){

            @Override
            public T handle(ResultSet resultSet) throws SQLException {
                if (useExecuteScalar) {
                    try {
                        return converter.convert(DefaultResultSetHandlerFactory.this.quirks.getRSVal(resultSet, 1));
                    }
                    catch (ConverterException e) {
                        throw new Sql2oException("Error occurred while converting value from database to type " + DefaultResultSetHandlerFactory.this.metadata.getType(), e);
                    }
                }
                Object pojo = DefaultResultSetHandlerFactory.this.metadata.getObjectConstructor().newInstance();
                for (int colIdx = 1; colIdx <= columnCount; ++colIdx) {
                    Setter setter = setters[colIdx];
                    if (setter == null) continue;
                    setter.setProperty(pojo, DefaultResultSetHandlerFactory.this.quirks.getRSVal(resultSet, colIdx));
                }
                return pojo;
            }
        };
    }

    private static class Key {
        final String stringKey;
        final DefaultResultSetHandlerFactory f;

        DefaultResultSetHandlerFactory factory() {
            return this.f;
        }

        private PojoMetadata getMetadata() {
            return this.f.metadata;
        }

        private Quirks getQuirksMode() {
            return this.f.quirks;
        }

        private Key(String stringKey, DefaultResultSetHandlerFactory f) {
            this.stringKey = stringKey;
            this.f = f;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.f.metadata.equals(key.getMetadata()) && this.f.quirks == key.getQuirksMode() && this.stringKey.equals(key.stringKey);
        }

        public int hashCode() {
            int result = this.f.metadata.hashCode();
            result = 31 * result + this.f.quirks.hashCode();
            result = 31 * result + this.stringKey.hashCode();
            return result;
        }
    }
}

