/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.sql2o.Sql2oException;
import org.sql2o.reflection.Setter;

public class MethodSetter
implements Setter {
    private Method method;
    private Class<?> type;

    public MethodSetter(Method method) {
        this.method = method;
        this.method.setAccessible(true);
        this.type = method.getParameterTypes()[0];
    }

    @Override
    public void setProperty(Object obj, Object value) {
        if (value == null && this.type.isPrimitive()) {
            return;
        }
        try {
            this.method.invoke(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new Sql2oException("error while calling setter method with name " + this.method.getName() + " on class " + obj.getClass().toString(), e);
        }
        catch (InvocationTargetException e) {
            throw new Sql2oException("error while calling setter method with name " + this.method.getName() + " on class " + obj.getClass().toString(), e);
        }
    }

    @Override
    public Class getType() {
        return this.type;
    }
}

