/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.reflection;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sql2o.tools.AbstractCache;

public class PojoIntrospector {
    private static final AbstractCache<Class<?>, Map<String, ReadableProperty>, Void> rpCache = new AbstractCache<Class<?>, Map<String, ReadableProperty>, Void>(){

        @Override
        protected Map<String, ReadableProperty> evaluate(Class<?> key, Void param) {
            return PojoIntrospector.collectReadableProperties(key);
        }
    };

    private static Map<String, ReadableProperty> collectReadableProperties(Class<?> cls) {
        HashMap<String, ReadableProperty> map = new HashMap<String, ReadableProperty>();
        List<Class<?>> classList = PojoIntrospector.classInheritanceHierarhy(cls, Object.class);
        for (Class<?> aClass : classList) {
            PojoIntrospector.collectPropertyGetters(map, aClass);
        }
        for (Class<?> aClass : classList) {
            PojoIntrospector.collectReadableFields(map, aClass);
        }
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, ReadableProperty> readableProperties(Class<?> ofClass) {
        return rpCache.get(ofClass, null);
    }

    private static void collectReadableFields(Map<String, ReadableProperty> map, Class<?> cls) {
        for (final Field m : cls.getDeclaredFields()) {
            String propName;
            if (PojoIntrospector.isStaticOrPrivate(m) || map.containsKey(propName = m.getName())) continue;
            Class<?> returnType = m.getType();
            m.setAccessible(true);
            ReadableProperty rp = new ReadableProperty(propName, returnType){

                @Override
                public Object get(Object instance) throws InvocationTargetException, IllegalAccessException {
                    return m.get(instance);
                }
            };
            map.put(propName, rp);
        }
    }

    private static boolean isStaticOrPrivate(Member m) {
        int modifiers = m.getModifiers();
        return Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers);
    }

    private static void collectPropertyGetters(Map<String, ReadableProperty> map, Class<?> cls) {
        for (final Method m : cls.getDeclaredMethods()) {
            Class<?> returnType;
            if (Modifier.isStatic(m.getModifiers()) || Modifier.isPrivate(m.getModifiers()) || 0 != m.getParameterTypes().length || (returnType = m.getReturnType()) == Void.TYPE || returnType == Void.class) continue;
            String name = m.getName();
            String propName = null;
            if (name.startsWith("get") && name.length() > 3) {
                propName = Introspector.decapitalize(name.substring(3));
            } else if (name.startsWith("is") && name.length() > 2 && returnType == Boolean.TYPE) {
                propName = Introspector.decapitalize(name.substring(2));
            }
            if (propName == null || map.containsKey(propName)) continue;
            m.setAccessible(true);
            ReadableProperty rp = new ReadableProperty(propName, returnType){

                @Override
                public Object get(Object instance) throws InvocationTargetException, IllegalAccessException {
                    return m.invoke(instance, (Object[])null);
                }
            };
            map.put(propName, rp);
        }
    }

    private static List<Class<?>> classInheritanceHierarhy(Class<?> cls, Class<Object> stopAt) {
        ArrayList list = new ArrayList();
        while (cls != null && cls != stopAt) {
            list.add(cls);
            cls = cls.getSuperclass();
        }
        return list;
    }

    public static abstract class ReadableProperty {
        public final String name;
        public final Class<?> type;

        private ReadableProperty(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public abstract Object get(Object var1) throws InvocationTargetException, IllegalAccessException;
    }
}

