/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.sql2o.Sql2oException;
import org.sql2o.reflection.ObjectConstructor;
import org.sql2o.reflection.ObjectConstructorFactory;

public class ReflectionObjectConstructorFactory
implements ObjectConstructorFactory {
    @Override
    public ObjectConstructor newConstructor(final Class<?> clazz) {
        try {
            final Constructor<?> ctor = clazz.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return new ObjectConstructor(){

                @Override
                public Object newInstance() {
                    try {
                        return ctor.newInstance(null);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new Sql2oException("Could not create a new instance of class " + clazz, e);
                    }
                }
            };
        }
        catch (Throwable e) {
            throw new Sql2oException("Could not find parameter-less constructor of class " + clazz, e);
        }
    }
}

