/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.swagger;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.definesys.mpaas.swagger.exception.S2dException;
import com.definesys.mpaas.swagger.markdown.ApiFragment;
import com.definesys.mpaas.swagger.markdown.ApiOperatorFragmet;
import com.definesys.mpaas.swagger.markdown.CoverPage;
import com.definesys.mpaas.swagger.markdown.SidebarPage;
import com.definesys.mpaas.swagger.model.Api;
import com.definesys.mpaas.swagger.model.ApiInfo;
import com.definesys.mpaas.swagger.model.ApiOperator;
import com.definesys.mpaas.swagger.model.Document;
import com.definesys.mpaas.swagger.model.Field;
import com.definesys.mpaas.swagger.model.HttpResponse;
import com.definesys.mpaas.swagger.model.Nav;
import com.definesys.mpaas.swagger.model.Parameter;
import com.definesys.mpaas.swagger.model.Response;
import com.definesys.mpaas.swagger.util.AppUtil;
import com.definesys.mpaas.swagger.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Swagger2docsify {
    private Document document = new Document();
    private List<Parameter> definitions;
    private List<Api> apiList;
    private List<ApiOperator> apiOperators;
    private String path;
    private String apiContent;
    private String saveDirectory;
    private String serverURL;
    private String token;
    private String root;
    public static final String REF = "yaya_ref";

    public static Swagger2docsify build() {
        return new Swagger2docsify();
    }

    public Swagger2docsify api(String url) {
        this.path = url;
        return this;
    }

    public Swagger2docsify save(String path) {
        this.saveDirectory = path;
        return this;
    }

    public Swagger2docsify upload(String url) {
        this.serverURL = url;
        return this;
    }

    public Swagger2docsify token(String token) {
        this.token = token;
        return this;
    }

    public Swagger2docsify code(String code) {
        this.root = code;
        return this;
    }

    public static Swagger2docsify build(String location, String saveDirectory, String remote, String token, String id) {
        Swagger2docsify sw = new Swagger2docsify();
        sw.setPath(location);
        sw.setSaveDirectory(saveDirectory);
        sw.setServerURL(remote);
        sw.setToken(token);
        sw.setApiContent(sw.readApiContent(location));
        sw.setRoot(id);
        return sw;
    }

    public String readApiContent(String location) {
        if (location == null) {
            location = "http://localhost:8080/v2/api-docs";
        }
        Log.log("api-docs====>%s", location);
        if (location.contains("http")) {
            if (location.equals("http://localhost:8080") || location.equals("http://localhost:8080/") || location.equals("http://127.0.0.1:8080") || location.equals("http://127.0.0.1:8080/")) {
                location = location + "/v2/api-docs";
            }
            try {
                this.setApiContent(AppUtil.doGet(location));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new S2dException(e);
            }
        }
        try {
            this.setApiContent(AppUtil.readTextFile(location));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new S2dException(e);
        }
        return this.getApiContent();
    }

    /*
     * WARNING - void declaration
     */
    public String generateDocument() {
        void var6_10;
        this.setApiContent(this.readApiContent(this.path));
        JSONObject doc = JSONObject.parseObject((String)this.apiContent);
        Log.log("definitions parse....", new Object[0]);
        this.parseDefinitions(doc.getJSONObject("definitions"));
        Log.log("api parse....", new Object[0]);
        this.buildApi(doc.getJSONArray("tags"));
        Log.log("ApiOperator parse....", new Object[0]);
        this.buildApiOperator(doc.getJSONObject("paths"));
        Log.log("ApiInfo parse....", new Object[0]);
        this.document.setApiInfo(this.buildApiInfo(doc.getJSONObject("info")));
        this.document.setApi(this.apiList);
        this.document.setNav(this.buildNav(this.document));
        SidebarPage sidebarPage = new SidebarPage(this.document.getNav());
        CoverPage coverPage = new CoverPage(this.document.getApiInfo());
        ArrayList<ApiFragment> apiFragments = new ArrayList<ApiFragment>();
        for (Api api : this.apiList) {
            ArrayList<ApiOperatorFragmet> apiOperatorFragmets = new ArrayList<ApiOperatorFragmet>();
            for (ApiOperator op : api.getApiOperators()) {
                apiOperatorFragmets.add(new ApiOperatorFragmet(op));
            }
            ApiFragment apiFragment = new ApiFragment(api, apiOperatorFragmets);
            apiFragment.markup();
            apiFragments.add(apiFragment);
        }
        if (this.saveDirectory == null) {
            this.saveDirectory = System.getProperty("java.io.tmpdir");
        }
        Log.log("saveDirectory===>%s", this.saveDirectory);
        if (!this.saveDirectory.endsWith("/")) {
            this.saveDirectory = this.saveDirectory + "/";
        }
        sidebarPage.markup();
        coverPage.markup();
        sidebarPage.save2File(this.saveDirectory + "_sidebar.md");
        coverPage.save2File(this.saveDirectory + "_coverpage.md");
        StringBuffer buffer = new StringBuffer();
        for (ApiFragment f : apiFragments) {
            f.save2File(this.saveDirectory + f.getApi().getId() + ".md");
            buffer.append(f.contet());
            buffer.append("\r\n");
            for (ApiOperatorFragmet fo : f.getApiOperatorFragmets()) {
                fo.save2File(this.saveDirectory + fo.getData().getId() + ".md");
            }
        }
        AppUtil.writeTextFile(this.saveDirectory + "README.md", buffer.toString());
        this.buildResources(this.document, this.saveDirectory);
        String string = "\u751f\u6210\u6210\u529f";
        if (this.getServerURL() != null) {
            String ss = this.uploadToServer(this.saveDirectory);
            String string2 = string + " \u63a5\u53e3\u5730\u5740:" + ss;
        }
        return var6_10;
    }

    private void buildResources(Document document, String path) {
        InputStream f1 = this.getClass().getResourceAsStream("/index.html");
        try {
            byte[] buf = new byte[f1.available()];
            f1.read(buf);
            String content = new String(buf, "UTF-8");
            content = content.replaceAll("\\{title\\}", document.getApiInfo().getTitle());
            File file = new File(path + "index.html");
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fout = new FileOutputStream(file);
            fout.write(content.getBytes("utf-8"));
            fout.close();
            this.buildStaticResource("logo.png", path);
            path = path + "/resources/";
            this.buildStaticResource("vue.css", path);
            this.buildStaticResource("docsify.min.js", path);
            this.buildStaticResource("search.min.js", path);
            this.buildStaticResource("prism-java.min.js", path);
            this.buildStaticResource("prism-sql.min.js", path);
            this.buildStaticResource("prism-json.min.js", path);
            this.buildStaticResource("prism-bash.min.js", path);
            this.buildStaticResource("prism-properties.min.js", path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void buildStaticResource(String fileName, String savePath) {
        InputStream f1 = this.getClass().getResourceAsStream("/" + fileName);
        try {
            byte[] buf = new byte[f1.available()];
            f1.read(buf);
            File dir = new File(savePath);
            dir.mkdirs();
            File file = new File(savePath + fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fout = new FileOutputStream(file);
            fout.write(buf);
            fout.flush();
            fout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ApiInfo buildApiInfo(JSONObject info) {
        ApiInfo apiInfo = new ApiInfo();
        apiInfo.setTitle(info.getString("title"));
        apiInfo.setVersion(info.getString("version"));
        apiInfo.setSlogon(info.getString("description"));
        return apiInfo;
    }

    private List<Nav> buildNav(Document document) {
        ArrayList<Nav> navs = new ArrayList<Nav>();
        int index = 1;
        for (Api api : document.getApi()) {
            api.setId("api_" + index);
            Nav nav = new Nav(api.getName(), api.getId());
            int m = 1;
            for (ApiOperator op : api.getApiOperators()) {
                op.setId(api.getId() + "_" + m++);
                nav.addChild(op.getName(), op.getId());
            }
            ++index;
            navs.add(nav);
        }
        return navs;
    }

    private List<Api> buildApi(JSONArray array) {
        this.apiList = new ArrayList<Api>();
        for (int i = 0; i < array.size(); ++i) {
            Api api = new Api();
            JSONObject item = array.getJSONObject(i);
            api.setDesc(item.getString("description"));
            api.setController(item.getString("name"));
            if (api.getDesc() != null) {
                api.setName(api.getDesc());
            } else {
                api.setName(api.getController());
            }
            this.apiList.add(api);
        }
        return this.apiList;
    }

    List<ApiOperator> buildApiOperator(JSONObject data) {
        this.apiOperators = new ArrayList<ApiOperator>();
        for (String s : data.getInnerMap().keySet()) {
            JSONObject item = data.getJSONObject(s);
            for (String s1 : item.getInnerMap().keySet()) {
                JSONObject v = item.getJSONObject(s1);
                ApiOperator op = new ApiOperator();
                op.setMethod(s1.toUpperCase());
                op.setPath(s);
                op.setName(v.getString("summary"));
                op.setInput(this.parseParameters(v.getJSONArray("parameters")));
                op.setOutput(this.parseResponse(v.getJSONObject("responses")));
                op.setApi(v.getJSONArray("tags").getString(0));
                op.setOutput(this.parseResponse(v.getJSONObject("responses")));
                this.findApi(op.getApi()).addApiOperator(op);
                this.apiOperators.add(op);
            }
        }
        return this.apiOperators;
    }

    private List<Parameter> parseDefinitions(JSONObject item) {
        this.definitions = new ArrayList<Parameter>();
        if (item == null) {
            return this.definitions;
        }
        Map data = item.getInnerMap();
        for (String s : data.keySet()) {
            Parameter p = new Parameter();
            JSONObject v = item.getJSONObject(s);
            p.setName(s);
            JSONObject properties = v.getJSONObject("properties");
            Object[] requiredArray = null;
            if (v.getJSONArray("required") != null) {
                requiredArray = v.getJSONArray("required").toArray();
            }
            if (properties != null) {
                block1: for (String s1 : properties.getInnerMap().keySet()) {
                    JSONObject p1 = properties.getJSONObject(s1);
                    Field f = new Field();
                    f.setName(s1);
                    f.setType(p1.getString("type"));
                    f.setFormat(p1.getString("format"));
                    f.setDesc(p1.getString("description"));
                    p.addField(f);
                    p.setRef(true);
                    if ("array".equalsIgnoreCase(f.getType())) {
                        if (p1.getJSONObject("items").getString(REF) != null) {
                            f.setRef(p1.getJSONObject("items").getString(REF));
                        } else {
                            f.setType(p1.getJSONObject("items").getString("type"));
                        }
                    }
                    if (p1.getString(REF) != null) {
                        f.setRef(p1.getString(REF));
                    }
                    if (f.getType() == null) {
                        f.setType(AppUtil.parseRefName(f.getRef()));
                    }
                    if (f.isRequired() || requiredArray == null) continue;
                    for (Object ob : requiredArray) {
                        if (!ob.toString().equals(f.getName())) continue;
                        f.setRequired(true);
                        continue block1;
                    }
                }
            }
            this.definitions.add(p);
        }
        for (Parameter p : this.definitions) {
            for (Field f : p.getFields()) {
                if (f.getRef() == null) continue;
                f.setSchema(this.findDefinition(f.getRef()));
            }
        }
        return this.definitions;
    }

    private void handleArray(Field f, JSONObject p1) {
        if ("array".equalsIgnoreCase(p1.getString("type"))) {
            f.setType("array");
            if (p1.getJSONObject("items").getString(REF) != null) {
                f.setRef(p1.getJSONObject("items").getString(REF));
                f.setSchema(this.findDefinition(f.getRef()));
            } else {
                f.setRef(p1.getJSONObject("items").getString("type"));
            }
        }
        if (p1.getString(REF) != null) {
            f.setRef(p1.getString(REF));
        }
    }

    private Parameter findDefinition(String location) {
        if (location == null) {
            return new Parameter();
        }
        String name = location.substring(location.lastIndexOf("/") + 1);
        for (Parameter p : this.definitions) {
            if (!name.equalsIgnoreCase(p.getName())) continue;
            return p;
        }
        return new Parameter();
    }

    private Api findApi(String api) {
        for (Api a : this.apiList) {
            if (!a.getName().equalsIgnoreCase(api) && !a.getController().equalsIgnoreCase(api)) continue;
            return a;
        }
        return null;
    }

    private List<Parameter> parseParameters(JSONArray parameters) {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        if (parameters != null && parameters.size() > 0) {
            for (int i = 0; i < parameters.size(); ++i) {
                JSONObject p = parameters.getJSONObject(i);
                JSONObject schema = p.getJSONObject("schema");
                if (schema != null) {
                    result.add(this.findDefinition(schema.getString(REF)));
                    continue;
                }
                Parameter vp = new Parameter();
                Field f = new Field();
                f.setName(p.getString("name"));
                f.setDesc(p.getString("description"));
                if (f.getName().equals(f.getDesc())) {
                    f.setDesc(null);
                }
                f.setRequired(p.getBoolean("required"));
                f.setType(p.getString("type"));
                f.setFormat(p.getString("format"));
                vp.addField(f);
                result.add(vp);
            }
        }
        return result;
    }

    private Response parseResponse(JSONObject response) {
        JSONObject code200 = response.getJSONObject("200");
        Response res = new Response();
        res.setType(code200.getString("type"));
        res.setDescription(code200.getString("description"));
        if ("array".equalsIgnoreCase(res.getType())) {
            res.setSchema(this.findDefinition(code200.getJSONObject("items").getString(REF)));
        }
        if (code200.getString(REF) != null) {
            res.setSchema(this.findDefinition(code200.getString(REF)));
        }
        if (code200.getString("schema") != null) {
            String ref = code200.getJSONObject("schema").getString(REF);
            if (ref == null) {
                String type = code200.getJSONObject("schema").getString("type");
                String format = code200.getJSONObject("schema").getString("format");
                Parameter p = new Parameter();
                Field f = new Field();
                f.setType(type);
                f.setFormat(format);
                if ("array".equals(type)) {
                    this.handleArray(f, code200.getJSONObject("schema"));
                }
                p.addField(f);
                res.setSchema(p);
            } else {
                res.setSchema(this.findDefinition(code200.getJSONObject("schema").getString(REF)));
            }
        }
        return res;
    }

    public String uploadToServer(String path) {
        if (this.getServerURL() == null) {
            throw new S2dException("server url is null");
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("token", this.token);
        data.put("root", this.root);
        data.put("data", this.zipResource2base64(path));
        HttpResponse result = null;
        try {
            Log.log("uploading data to %s...", this.getServerURL());
            String d = JSON.toJSONString(data);
            Log.log("data size==>%s", String.valueOf(d.length()));
            String rs = AppUtil.doPost(this.getServerURL(), d);
            result = (HttpResponse)JSON.parseObject((String)rs, HttpResponse.class);
            if (result.isOk()) {
                Log.error("uploading success access url:%s", result.getMessage());
            } else {
                Log.error("upload failed message:%s", result.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.error("upload failed system failed:%s", e.getMessage());
            throw new S2dException(e);
        }
        return result.getMessage();
    }

    public String zipResource2base64(String path) {
        Log.log("path:%s", path);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(bos);
        out.setLevel(9);
        File p = new File(path);
        try {
            for (File f : p.listFiles()) {
                if (!f.isFile() || f.isHidden()) continue;
                Log.log("file:%s", f.getName());
                ZipEntry zip = new ZipEntry(f.getName());
                FileInputStream fin = new FileInputStream(f);
                byte[] buf = new byte[fin.available()];
                fin.read(buf);
                out.putNextEntry(zip);
                out.write(buf);
            }
            out.closeEntry();
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new S2dException(ex);
        }
        String s = AppUtil.encode64(bos.toByteArray());
        return s;
    }

    public String generateExampleData(List<Parameter> parameters) {
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getApiContent() {
        return this.apiContent;
    }

    public void setApiContent(String apiContent) {
        apiContent = apiContent.replaceAll("\"\\$ref\":\"#/definitions/ObjectId\"", "\"type\":\"string\"");
        this.apiContent = apiContent.replaceAll("\\$ref", REF);
    }

    public String getSaveDirectory() {
        return this.saveDirectory;
    }

    public void setSaveDirectory(String saveDirectory) {
        this.saveDirectory = saveDirectory;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }
}

