/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.swagger.markdown;

import com.definesys.mpaas.swagger.markdown.MarkdownFragment;
import com.definesys.mpaas.swagger.model.ApiOperator;
import com.definesys.mpaas.swagger.model.Field;
import com.definesys.mpaas.swagger.model.Parameter;
import com.definesys.mpaas.swagger.model.Response;
import com.definesys.mpaas.swagger.util.AppUtil;
import java.util.ArrayList;
import java.util.List;

public class ApiOperatorFragmet
extends MarkdownFragment {
    private ApiOperator data;
    private int recursionCount = 0;

    public ApiOperatorFragmet(ApiOperator apiOperator) {
        this.data = apiOperator;
    }

    @Override
    public String markup() {
        if (this.data.getName() != null) {
            if (this.data.getFunction() == null) {
                this.docTopTitle(this.f("%s", this.data.getName()));
            } else {
                this.docTopTitle(this.f("%s  <small>%s</small>", this.data.getName(), this.data.getFunction()));
            }
            this.docSubTitle("\u63a5\u53e3\u4fe1\u606f");
            this.tableHeader("\u5c5e\u6027", "\u503c");
            this.tableRow("\u8bf7\u6c42\u65b9\u6cd5", this.data.getMethod());
            this.tableRow("\u8def\u5f84", this.data.getPath());
            this.tableRow("\u63cf\u8ff0", this.data.getName());
            this.line();
            this.docSubTitle("\u8f93\u5165\u53c2\u6570");
            this.tableHeader("\u53c2\u6570\u540d", "\u5fc5\u9009", "\u7c7b\u578b", "\u8bf4\u660e");
            this.parameterMarkup(this.data.getInput(), "\u65e0\u8f93\u5165\u53c2\u6570");
            this.line();
            this.docSubTitle("\u8f93\u5165\u793a\u4f8b");
            this.highlight("json", this.data.getInputExample());
            this.line();
            this.docSubTitle("\u8f93\u51fa\u53c2\u6570");
            this.tableHeader("\u53c2\u6570\u540d", "\u7c7b\u578b", "\u8bf4\u660e");
            this.responseMarkup(this.data.getOutput(), "\u65e0\u8f93\u51fa\u53c2\u6570");
            this.line();
            this.docSubTitle("\u8f93\u51fa\u793a\u4f8b");
            this.highlight("json", this.data.getOutputExample());
        }
        return this.contet();
    }

    private void parameterMarkup(List<Parameter> ps, String tip) {
        if (ps == null || ps.size() == 0) {
            this.tableRow(this.f("`%s`", tip));
        } else {
            for (Parameter p : ps) {
                if (p.getName() != null && ps.size() > 1) {
                    this.tableRow(this.f("`%s`", p.getName()));
                }
                if (p.getFields() == null) continue;
                for (Field fd : p.getFields()) {
                    this.tableRow(fd.getName(), fd.isRequired() ? "\u662f" : "\u5426", fd.getHumanType(), fd.getDesc());
                }
            }
        }
    }

    private void responseMarkup(Response response, String tip) {
        if (response == null) {
            this.tableRow(this.f("`%s`", tip));
        } else {
            this.parameterMarkup(response.getSchema(), false);
        }
    }

    private void parameterMarkup(Parameter p, boolean inner) {
        if (p == null) {
            return;
        }
        ArrayList<Parameter> ps = new ArrayList<Parameter>();
        boolean bok = false;
        if (p.getFields() != null) {
            for (Field fd : p.getFields()) {
                if (fd.getSchema() == null || !fd.getSchema().isRef()) continue;
                bok = true;
            }
        }
        if (p.getName() != null && bok || inner) {
            this.tableRow(this.f("`%s`", p.getName()));
        }
        if (p.getFields() != null) {
            for (Field fd : p.getFields()) {
                String type = fd.getType();
                type = fd.getRef() != null ? ("array".equals(fd.getType()) ? "`array<" + AppUtil.parseRefName(fd.getRef()) + ">`" : "`" + type + "`") : fd.getHumanType();
                String name = fd.getName() == null ? "\u65e0" : fd.getName();
                this.tableRow(name, type, fd.getDesc());
                if (fd.getSchema() == null || !fd.getSchema().isRef()) continue;
                ps.add(fd.getSchema());
            }
        }
        for (Parameter p1 : ps) {
            if (p1.getName().equals(p.getName())) {
                ++this.recursionCount;
            }
            if (this.recursionCount >= 1) continue;
            this.parameterMarkup(p1, true);
        }
    }

    public ApiOperator getData() {
        return this.data;
    }

    public void setData(ApiOperator data) {
        this.data = data;
    }
}

