/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.swagger.markdown;

import java.io.File;
import java.io.FileOutputStream;

public abstract class MarkdownFragment {
    protected StringBuffer content = new StringBuffer();

    public abstract String markup();

    public String f(String format, Object ... params) {
        return String.format(format, params);
    }

    public MarkdownFragment title(String title) {
        return this.title("#", title);
    }

    public MarkdownFragment title(String level, String title) {
        this.append(level, new Object[0]);
        this.append(" ", new Object[0]);
        this.append(title, new Object[0]);
        this.doubleLine();
        return this;
    }

    public MarkdownFragment title(int level, String title) {
        String s = "";
        for (int i = 0; i < level; ++i) {
            s = s + "#";
        }
        return this.title(s, title);
    }

    public MarkdownFragment docTopTitle(String title) {
        this.append("> ###### ", new Object[0]);
        this.append(title, new Object[0]);
        this.doubleLine();
        return this;
    }

    public MarkdownFragment docSubTitle(String title) {
        this.append("- ##### ", new Object[0]);
        this.append(title, new Object[0]);
        this.doubleLine();
        return this;
    }

    public MarkdownFragment tableHeader(String ... title) {
        for (String s : title) {
            this.append(s, new Object[0]);
            this.append("|", new Object[0]);
        }
        this.line();
        for (String s : title) {
            this.append("---", new Object[0]);
            this.append("|", new Object[0]);
        }
        this.line();
        return this;
    }

    public MarkdownFragment tableRow(String ... title) {
        for (String s : title) {
            this.append(s == null ? "" : s, new Object[0]);
            this.append("|", new Object[0]);
        }
        this.line();
        return this;
    }

    public MarkdownFragment bold(String content) {
        this.append(this.f("***%s***", content), new Object[0]);
        this.doubleLine();
        return this;
    }

    public MarkdownFragment highlight(String language, String content) {
        this.append("```", new Object[0]);
        this.append(language, new Object[0]);
        this.line();
        this.append(content, new Object[0]);
        this.line();
        this.append("```", new Object[0]);
        this.doubleLine();
        return this;
    }

    public MarkdownFragment link(String desc, String url) {
        this.append("[%s](%s)", desc, url);
        this.line();
        return this;
    }

    public MarkdownFragment list(String item) {
        this.append("- ", new Object[0]);
        this.append(item, new Object[0]);
        this.line();
        return this;
    }

    public MarkdownFragment quote(String item) {
        this.append("> ", new Object[0]);
        this.append(item, new Object[0]);
        this.line();
        return this;
    }

    public MarkdownFragment image(String src) {
        return this.append("![logo](%s)", src);
    }

    public MarkdownFragment nav(String title) {
        this.list(title);
        this.line();
        return this;
    }

    public MarkdownFragment navLink(String title, String href) {
        this.append(" - [%s](%s)", title, href);
        this.line();
        return this;
    }

    public MarkdownFragment append(String format, Object ... params) {
        if (params == null || params.length == 0) {
            this.content.append(format);
        } else {
            this.content.append(this.f(format, params));
        }
        return this;
    }

    public MarkdownFragment line() {
        return this.line(1);
    }

    public MarkdownFragment doubleLine() {
        return this.line(2);
    }

    public MarkdownFragment line(int number) {
        for (int i = 0; i < number; ++i) {
            this.content.append("\r\n");
        }
        return this;
    }

    public String contet() {
        return this.content.toString();
    }

    public void save2File(String file) {
        File f = new File(file);
        File path = new File(f.getParent());
        path.mkdirs();
        try {
            if (!f.exists() || !f.isFile()) {
                f.createNewFile();
            }
            FileOutputStream fout = new FileOutputStream(f, false);
            fout.write(this.contet().getBytes("UTF-8"));
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

