/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.swagger.model;

import com.alibaba.fastjson.JSON;
import com.definesys.mpaas.swagger.model.Field;
import com.definesys.mpaas.swagger.model.Parameter;
import com.definesys.mpaas.swagger.model.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ApiOperator {
    private String method;
    private String path;
    private List<Parameter> input = new ArrayList<Parameter>();
    private String inputExample;
    private Response output;
    private String outputExample;
    private String remark;
    private String name;
    private String function;
    private String id;
    private String api;

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<Parameter> getInput() {
        return this.input;
    }

    public void setInput(List<Parameter> input) {
        this.input = input;
    }

    public String getInputExample() {
        if (this.input != null && this.input.size() > 0) {
            if ("GET".equalsIgnoreCase(this.method)) {
                return this.generateParameterURL();
            }
            return JSON.toJSONString(this.input.get(0).toMap(), (boolean)true);
        }
        return "\u65e0\u8f93\u5165\u53c2\u6570";
    }

    private String generateParameterURL() {
        StringBuffer buf = new StringBuffer();
        for (Parameter p : this.input) {
            if (buf.length() > 0) {
                buf.append("&");
            }
            Map<String, Object> m = p.toMap();
            for (String key : m.keySet()) {
                buf.append(String.format("%s=%s", key, m.get(key)));
            }
        }
        return buf.toString();
    }

    public void setInputExample(String inputExample) {
        this.inputExample = inputExample;
    }

    public Response getOutput() {
        return this.output;
    }

    public void setOutput(Response output) {
        this.output = output;
    }

    public String getOutputExample() {
        if (this.output != null && this.output.getSchema() != null) {
            List<Field> fs = this.output.getSchema().getFields();
            Map<String, Object> output = this.output.getSchema().toMap();
            if (fs.size() == 1) {
                Field f = fs.get(0);
                if (f.isString()) {
                    return "\"" + output.get(f.getName()) + "\"";
                }
                return JSON.toJSONString((Object)output.get(f.getName()), (boolean)true);
            }
            return JSON.toJSONString(this.output.getSchema().toMap(), (boolean)true);
        }
        return "\u65e0\u8f93\u51fa\u53c2\u6570";
    }

    public void setOutputExample(String outputExample) {
        this.outputExample = outputExample;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }
}

