/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.swagger.model;

import com.definesys.mpaas.swagger.model.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Parameter {
    private String name;
    private boolean ref = false;
    private List<Field> fields = new ArrayList<Field>();
    private List<String> required = new ArrayList<String>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public void addField(Field f) {
        this.fields.add(f);
    }

    public boolean isRef() {
        return this.ref;
    }

    public void setRef(boolean ref) {
        this.ref = ref;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        int recursionCount = 0;
        for (Field f : this.fields) {
            String format;
            String type = f.getType();
            ArrayList<Object> value = this.getSampleValue(type, format = f.getFormat());
            if (value == null) {
                if ("array".equals(type)) {
                    ArrayList<Object> array;
                    if (f.getSchema() != null) {
                        array = new ArrayList<Object>();
                        if (f.getSchema().getName().equals(this.getName())) {
                            array.add(new HashMap());
                        } else {
                            array.add(f.getSchema().toMap());
                        }
                        value = array;
                    } else {
                        array = new ArrayList();
                        array.add(this.getSampleValue(f.getRef(), f.getFormat()));
                        value = array;
                    }
                } else if (f.getRef() != null && f.getSchema() != null && recursionCount < 1) {
                    if (type.equals(f.getSchema().getClass().getTypeName())) {
                        ++recursionCount;
                    }
                    value = f.getSchema().toMap();
                }
            }
            m.put(f.getName(), value);
        }
        return m;
    }

    private Object getSampleValue(String type, String format) {
        Serializable value = null;
        if ("string".equals(type)) {
            value = "string";
            if ("date-time".equals(format)) {
                value = Calendar.getInstance().getTime().toString();
            }
        } else if ("integer".equals(type)) {
            value = 0;
        } else if ("number".equals(type)) {
            value = 0;
            if ("double".equals(format)) {
                value = new Double(0.0);
            } else if ("float".equals(format)) {
                value = new Float(0.0f);
            }
        } else if ("object".equals(type)) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("key", "value");
            value = data;
        } else if ("boolean".equals(type)) {
            value = true;
        }
        return value;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public void setRequired(List<String> required) {
        this.required = required;
    }

    public boolean fieldRequired(String field) {
        for (String s : this.required) {
            if (!s.equals(field)) continue;
            return true;
        }
        return false;
    }
}

