/*
 * Decompiled with CFR 0.152.
 */
package com.albanoi.spring.gateway;

import com.albanoi.Command;
import com.albanoi.CommandHandler;
import com.albanoi.CommandResult;
import com.albanoi.spring.gateway.AlbanoiGateway;
import com.albanoi.spring.gateway.exceptions.MissingHandlerException;
import com.albanoi.spring.gateway.exceptions.MultipleHandlersException;
import org.albanoi.Query;
import org.albanoi.QueryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;

public class DefaultAlbanoiGateway
implements AlbanoiGateway {
    @Autowired
    private ApplicationContext applicationContext;
    private final Logger logger = LoggerFactory.getLogger(DefaultAlbanoiGateway.class);

    @Override
    public <R, C extends Command> CommandResult<R> execute(C command, Class<R> resultType) {
        this.logger.trace("Looking for registered command handlers for the following generic parameters {}, {}", command.getClass(), resultType);
        String[] registeredHandlerNames = this.applicationContext.getBeanNamesForType(ResolvableType.forClassWithGenerics(CommandHandler.class, (Class[])new Class[]{command.getClass(), resultType}));
        if (registeredHandlerNames.length == 0) {
            this.logger.error("Looks like there is no handler registered for {}", command.getClass());
            throw new MissingHandlerException(command);
        }
        if (registeredHandlerNames.length > 1) {
            this.logger.error("Looks like on your application there are multiple command handlers for {}", command.getClass());
            throw new MultipleHandlersException(command, registeredHandlerNames);
        }
        String handlerName = registeredHandlerNames[0];
        this.logger.trace("Fine, there is only one handler registered and that is {}", (Object)handlerName);
        CommandHandler handler = (CommandHandler)this.applicationContext.getBean(handlerName);
        CommandResult executionResult = handler.execute(command);
        return executionResult;
    }

    @Override
    public <Q extends Query, R> R handle(Q query, Class<R> resultType) {
        this.logger.trace("Looking for registered query handlers for the following query type {}", (Object)query.getClass().getSimpleName());
        String[] registeredQueryHandlers = this.applicationContext.getBeanNamesForType(ResolvableType.forClassWithGenerics(QueryHandler.class, (Class[])new Class[]{query.getClass(), resultType}));
        if (registeredQueryHandlers.length == 0) {
            this.logger.error("Looks like there is no handler registered for {}", query.getClass());
            throw new MissingHandlerException(query);
        }
        if (registeredQueryHandlers.length > 1) {
            this.logger.error("Looks like on your application there are multiple command handlers for {}", query.getClass());
            throw new MultipleHandlersException(query, registeredQueryHandlers);
        }
        String handlerName = registeredQueryHandlers[0];
        this.logger.trace("Fine, there is only one handler registered and that is {}", (Object)handlerName);
        QueryHandler handler = (QueryHandler)this.applicationContext.getBean(handlerName);
        return (R)handler.handle(query);
    }
}

