/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook;

import com.deliveredtechnologies.rulebook.NameValueReferable;
import com.deliveredtechnologies.rulebook.NameValueReferableMap;
import com.deliveredtechnologies.rulebook.NameValueReferableTypeConvertibleMap;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class TypeConvertibleFactMap<T>
implements NameValueReferableTypeConvertibleMap<T> {
    NameValueReferableMap<T> _map;

    public TypeConvertibleFactMap(NameValueReferableMap<T> map) {
        this._map = map;
    }

    @Override
    public String getStrVal(String name) {
        if (this.getValue(name) instanceof String) {
            return (String)this.getValue(name);
        }
        return String.valueOf(this.getValue(name));
    }

    @Override
    public T getOne() {
        return this._map.getOne();
    }

    @Override
    public T getValue(String name) {
        return this._map.getValue(name);
    }

    @Override
    public Integer getIntVal(String name) {
        T value = this.getValue(name);
        if (value != null) {
            if (Integer.class == value.getClass()) {
                return (Integer)value;
            }
            if (value.getClass() == String.class) {
                return Integer.valueOf((String)value);
            }
        }
        return null;
    }

    @Override
    public Double getDblVal(String name) {
        T value = this.getValue(name);
        if (value != null) {
            if (value instanceof Float) {
                return ((Float)value).floatValue();
            }
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof Integer) {
                return (double)((Integer)value);
            }
            if (value instanceof Long) {
                return (double)((Long)value);
            }
            if (value instanceof String) {
                return Double.parseDouble((String)value);
            }
        }
        return null;
    }

    @Override
    public Boolean getBoolVal(String name) {
        T value = this.getValue(name);
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    @Override
    public BigDecimal getBigDeciVal(String name) {
        T value = this.getValue(name);
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value);
        }
        if (value instanceof Float) {
            return BigDecimal.valueOf(((Float)value).floatValue());
        }
        if (value instanceof Integer) {
            return BigDecimal.valueOf(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return BigDecimal.valueOf((Long)value);
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return null;
    }

    @Override
    public void setValue(String name, T obj) {
        this._map.setValue(name, obj);
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    @Override
    public NameValueReferable<T> get(Object key) {
        return (NameValueReferable)this._map.get(key);
    }

    @Override
    public NameValueReferable<T> put(NameValueReferable<T> ref) {
        return this._map.put(ref);
    }

    @Override
    public NameValueReferable<T> put(String key, NameValueReferable<T> value) {
        return this._map.put(key, value);
    }

    @Override
    public NameValueReferable<T> remove(Object key) {
        return (NameValueReferable)this._map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends NameValueReferable<T>> map) {
        this._map.putAll(map);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this._map.keySet();
    }

    @Override
    public Collection<NameValueReferable<T>> values() {
        return this._map.values();
    }

    @Override
    public Set<Map.Entry<String, NameValueReferable<T>>> entrySet() {
        return this._map.entrySet();
    }

    public String toString() {
        return this._map.toString();
    }
}

