/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.lang;

import com.deliveredtechnologies.rulebook.Fact;
import com.deliveredtechnologies.rulebook.NameValueReferable;
import com.deliveredtechnologies.rulebook.NameValueReferableMap;
import com.deliveredtechnologies.rulebook.NameValueReferableTypeConvertibleMap;
import com.deliveredtechnologies.rulebook.Result;
import com.deliveredtechnologies.rulebook.lang.GivenRuleBuilder;
import com.deliveredtechnologies.rulebook.lang.TerminatingRuleBuilder;
import com.deliveredtechnologies.rulebook.lang.ThenRuleBuilder;
import com.deliveredtechnologies.rulebook.lang.UsingRuleBuilder;
import com.deliveredtechnologies.rulebook.lang.WhenRuleBuilder;
import com.deliveredtechnologies.rulebook.model.AuditableRule;
import com.deliveredtechnologies.rulebook.model.GoldenRule;
import com.deliveredtechnologies.rulebook.model.Rule;
import com.deliveredtechnologies.rulebook.model.RuleChainActionType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBuilder<T, U>
implements TerminatingRuleBuilder<T, U> {
    private static Logger LOGGER = LoggerFactory.getLogger(RuleBuilder.class);
    private Class<? extends Rule> _ruleClass;
    private Class<T> _factType;
    private Class<U> _resultType;
    private RuleChainActionType _actionType = RuleChainActionType.CONTINUE_ON_FAILURE;
    private Optional<String> _name = Optional.empty();

    public static RuleBuilder<Object, Object> create(Class<? extends Rule> ruleClass, RuleChainActionType actionType) {
        return new RuleBuilder<Object, Object>(ruleClass, actionType);
    }

    public static RuleBuilder<Object, Object> create(Class<? extends Rule> ruleClass) {
        return new RuleBuilder<Object, Object>(ruleClass);
    }

    public static RuleBuilder<Object, Object> create() {
        RuleBuilder<Object, Object> rule = new RuleBuilder<Object, Object>(GoldenRule.class);
        rule._factType = Object.class;
        return rule;
    }

    private RuleBuilder(Class<? extends Rule> ruleClass) {
        this._ruleClass = ruleClass;
    }

    private RuleBuilder(Class<? extends Rule> ruleClass, RuleChainActionType actionType) {
        this(ruleClass);
        this._actionType = actionType;
    }

    public RuleBuilder<T, U> withName(String name) {
        this._name = Optional.of(name);
        return this;
    }

    public <S> RuleBuilder<S, U> withFactType(Class<S> factType) {
        RuleBuilder<T, U> builder = new RuleBuilder<T, U>(this._ruleClass);
        builder._factType = factType;
        builder._resultType = this._resultType;
        builder._actionType = this._actionType;
        return builder;
    }

    public <S> RuleBuilder<T, S> withResultType(Class<S> resultType) {
        RuleBuilder<T, U> builder = new RuleBuilder<T, U>(this._ruleClass);
        builder._factType = this._factType;
        builder._resultType = resultType;
        builder._actionType = this._actionType;
        return builder;
    }

    public GivenRuleBuilder<T, U> given(String name, T value) {
        Rule<T, U> rule = this._name.map(ruleName -> new AuditableRule<T, U>(this.newRule(), (String)ruleName)).orElse(this.newRule());
        if (rule == null) {
            throw new IllegalStateException("No Rule is instantiated; An invalid Rule class may have been provided");
        }
        return new GivenRuleBuilder<T, U>(rule, new Fact<T>(name, value));
    }

    @SafeVarargs
    public final GivenRuleBuilder<T, U> given(NameValueReferable ... facts) {
        Rule<T, U> rule = this._name.map(name -> new AuditableRule<T, U>(this.newRule(), (String)name)).orElse(this.newRule());
        if (rule == null) {
            throw new IllegalStateException("No Rule is instantiated; An invalid Rule class may have been provided");
        }
        return new GivenRuleBuilder<T, U>(rule, facts);
    }

    public final GivenRuleBuilder<T, U> given(NameValueReferableMap facts) {
        Rule<T, U> rule = this._name.map(name -> new AuditableRule<T, U>(this.newRule(), (String)name)).orElse(this.newRule());
        if (rule == null) {
            throw new IllegalStateException("No Rule is instantiated; An invalid Rule class may have been provided");
        }
        return new GivenRuleBuilder<T, U>(rule, facts);
    }

    public WhenRuleBuilder<T, U> when(Predicate<NameValueReferableTypeConvertibleMap<T>> condition) {
        Rule<T, U> rule = this._name.map(name -> new AuditableRule<T, U>(this.newRule(), (String)name)).orElse(this.newRule());
        if (rule == null) {
            throw new IllegalStateException("No Rule is instantiated; An invalid Rule class may have been provided");
        }
        return new WhenRuleBuilder<T, U>(rule, condition);
    }

    public UsingRuleBuilder<T, U> using(String ... factNames) {
        Rule<T, U> rule = this._name.map(name -> new AuditableRule<T, U>(this.newRule(), (String)name)).orElse(this.newRule());
        if (rule == null) {
            throw new IllegalStateException("No Rule is instantiated; An invalid Rule class may have been provided");
        }
        return new UsingRuleBuilder<T, U>(rule, factNames);
    }

    public ThenRuleBuilder<T, U> then(Consumer<NameValueReferableTypeConvertibleMap<T>> action) {
        Rule<T, U> rule = this._name.map(name -> new AuditableRule<T, U>(this.newRule(), (String)name)).orElse(this.newRule());
        if (rule == null) {
            throw new IllegalStateException("No Rule is instantiated; An invalid Rule class may have been provided");
        }
        return new ThenRuleBuilder<T, U>(rule, action);
    }

    public ThenRuleBuilder<T, U> then(BiConsumer<NameValueReferableTypeConvertibleMap<T>, Result<U>> action) {
        Rule<T, U> rule = this._name.map(name -> new AuditableRule<T, U>(this.newRule(), (String)name)).orElse(this.newRule());
        if (rule == null) {
            throw new IllegalStateException("No Rule is instantiated; An invalid Rule class may have been provided");
        }
        return new ThenRuleBuilder<T, U>(rule, action);
    }

    @Override
    public Rule<T, U> build() {
        return this.newRule();
    }

    private Rule<T, U> newRule() {
        if (this._actionType.equals((Object)RuleChainActionType.STOP_ON_FAILURE)) {
            try {
                Constructor<? extends Rule> constructor = this._ruleClass.getConstructor(Class.class, RuleChainActionType.class);
                return constructor.newInstance(new Object[]{this._factType, this._actionType});
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                LOGGER.error("Unable to create an instance of the specified Rule class '" + this._ruleClass + "' with the specified fact type and 'stopOnRuleFailire' boolean parameter");
                return null;
            }
        }
        try {
            Constructor<? extends Rule> constructor = this._ruleClass.getConstructor(Class.class, Class.class);
            return constructor.newInstance(this._factType, this._resultType);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            LOGGER.debug("Unable to create an instance of the specified Rule class '" + this._ruleClass + "' with fact and result types specified");
            try {
                Constructor<? extends Rule> constructor = this._ruleClass.getConstructor(Class.class);
                return constructor.newInstance(this._factType);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex2) {
                LOGGER.debug("Attempt to use a single argument constructor for specifying the Fact type failed", (Throwable)ex2);
                try {
                    Constructor<? extends Rule> constructor = this._ruleClass.getConstructor(new Class[0]);
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex3) {
                    LOGGER.debug("Attempt to use the default constructor failed for " + this._ruleClass, (Throwable)ex3);
                    LOGGER.error("Unable to create a Rule of type '" + this._ruleClass.getName() + "'");
                    return null;
                }
            }
        }
    }
}

