/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.model.runner;

import com.deliveredtechnologies.rulebook.NameValueReferableMap;
import com.deliveredtechnologies.rulebook.Result;
import com.deliveredtechnologies.rulebook.model.Auditable;
import com.deliveredtechnologies.rulebook.model.AuditableRule;
import com.deliveredtechnologies.rulebook.model.Auditor;
import com.deliveredtechnologies.rulebook.model.Rule;
import com.deliveredtechnologies.rulebook.model.RuleBook;
import com.deliveredtechnologies.rulebook.model.runner.RuleAdapter;
import com.deliveredtechnologies.rulebook.model.runner.RuleBookRunner;
import com.deliveredtechnologies.rulebook.util.AnnotationUtils;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuleBookRunner
extends Auditor
implements RuleBook {
    private static Logger LOGGER = LoggerFactory.getLogger(RuleBookRunner.class);
    private Class<? extends RuleBook> _prototypeClass;
    private Result _result = new Result<Object>(null);

    public AbstractRuleBookRunner(Class<? extends RuleBook> prototypeClass) {
        this._prototypeClass = prototypeClass;
    }

    @Override
    public void addRule(Rule rule) {
        throw new UnsupportedOperationException("Rules are only added to a RuleBookRunner on run()!");
    }

    @Override
    public void run(NameValueReferableMap facts) {
        this.getResult().ifPresent(Result::reset);
        try {
            RuleBook ruleBook = this._prototypeClass.newInstance();
            List<Class<?>> classes = this.getPojoRules();
            for (Class<?> rule : classes) {
                try {
                    AnnotationUtils.getAnnotatedField(com.deliveredtechnologies.rulebook.annotation.Result.class, rule).ifPresent(field -> ruleBook.setDefaultResult(this._result.getValue() == null ? new Object() : this._result.getValue()));
                    String name = AnnotationUtils.getAnnotation(com.deliveredtechnologies.rulebook.annotation.Rule.class, rule).name();
                    if (name.equals("None")) {
                        name = rule.getSimpleName();
                    }
                    AuditableRule ruleInstance = new AuditableRule(new RuleAdapter(rule.newInstance()), name);
                    ruleBook.addRule(ruleInstance);
                    ((Auditable)ruleInstance).setAuditor(this);
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    LOGGER.warn("Unable to create instance of rule using '" + rule + "'", (Throwable)ex);
                }
            }
            ruleBook.run(facts);
            Optional<Result<Result>> result = ruleBook.getResult();
            result.ifPresent(res -> this._result.setValue(res.getValue()));
        }
        catch (IOException | InvalidPathException ex) {
            LOGGER.error("Unable to find rule classes", (Throwable)ex);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            LOGGER.error("Unable to create an instance of '" + this._prototypeClass.getName() + "' with the default constructor", (Throwable)ex);
        }
    }

    public void setDefaultResult(Object result) {
        this._result = new Result<Object>(result);
    }

    public Optional<Result> getResult() {
        return this._result.getValue() == null ? Optional.empty() : Optional.of(this._result);
    }

    @Override
    public boolean hasRules() {
        try {
            return this.getPojoRules().size() > 0;
        }
        catch (InvalidPathException e) {
            LOGGER.error("Unable to find rule classes", (Throwable)e);
            return false;
        }
    }

    protected abstract List<Class<?>> getPojoRules();
}

