/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook;

import com.deliveredtechnologies.rulebook.Referable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Result<T>
implements Referable<T> {
    private Map<Long, T> _valueMap = new HashMap<Long, T>();
    private final ReentrantReadWriteLock _lock = new ReentrantReadWriteLock();
    private T _defaultValue = null;

    public Result() {
    }

    public Result(T value) {
        this._defaultValue = value;
    }

    public void reset() {
        this._lock.readLock().lock();
        try {
            if (this._defaultValue == null) {
                return;
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
        this.setValue(this._defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getValue() {
        this._lock.readLock().lock();
        try {
            long key = Thread.currentThread().getId();
            if (this._valueMap.containsKey(key)) {
                T t = this._valueMap.get(Thread.currentThread().getId());
                return t;
            }
            T t = this._defaultValue;
            return t;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    @Override
    public void setValue(T value) {
        this._lock.writeLock().lock();
        try {
            this._valueMap.put(Thread.currentThread().getId(), value);
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this._lock.readLock().lock();
        try {
            long key = Thread.currentThread().getId();
            if (this._valueMap.containsKey(key)) {
                String string = this._valueMap.get(key).toString();
                return string;
            }
            if (this._defaultValue != null) {
                String string = this._defaultValue.toString();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }
}

