/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.model.rulechain.cor;

import com.deliveredtechnologies.rulebook.NameValueReferableMap;
import com.deliveredtechnologies.rulebook.Result;
import com.deliveredtechnologies.rulebook.model.Rule;
import com.deliveredtechnologies.rulebook.model.RuleBook;
import com.deliveredtechnologies.rulebook.model.rulechain.cor.Handler;
import com.deliveredtechnologies.rulebook.model.rulechain.cor.RuleHandler;
import java.util.Optional;

public class CoRRuleBook<T>
implements RuleBook<T> {
    private Handler<Rule> _headRule = null;
    private Handler<Rule> _tailRule = null;
    private Result<T> _result = null;

    @Override
    public void addRule(Rule rule) {
        if (rule == null) {
            return;
        }
        RuleHandler ruleHandler = new RuleHandler(rule);
        if (this._headRule == null) {
            this.getResult().ifPresent(result -> rule.setResult(result));
            this._headRule = ruleHandler;
            this._tailRule = ruleHandler;
        } else {
            this._tailRule = this._tailRule.setSuccessor(ruleHandler);
        }
    }

    @Override
    public void run(NameValueReferableMap facts) {
        this.getResult().ifPresent(Result::reset);
        if (!this.hasRules()) {
            this.defineRules();
        }
        Optional<Handler<Rule>> headRule = Optional.ofNullable(this._headRule);
        headRule.ifPresent(ruleHandler -> {
            this.getResult().ifPresent(result -> ((Rule)ruleHandler.getDelegate()).setResult(result));
            ruleHandler.handleRequest(facts);
        });
    }

    @Override
    public void setDefaultResult(T result) {
        this._result = new Result<T>(result);
    }

    @Override
    public Optional<Result<T>> getResult() {
        return Optional.ofNullable(this._result);
    }

    @Override
    public boolean hasRules() {
        return this._headRule != null;
    }
}

