/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.util;

import java.lang.reflect.Array;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T> T[] combine(T[] array1, T[] array2) {
        return ArrayUtils.combine(array1, array2, array1.length + array2.length);
    }

    public static <T> T[] combine(T[] array1, T[] array2, int maxElements) {
        if (array1.length == maxElements) {
            return array1;
        }
        if (array1.length > maxElements) {
            Object[] combinedArray = (Object[])Array.newInstance(array1.getClass().getComponentType(), maxElements);
            System.arraycopy(array1, 0, combinedArray, 0, maxElements);
            return combinedArray;
        }
        maxElements = array1.length + array2.length >= maxElements ? maxElements : array1.length + array2.length;
        Object[] combinedArray = (Object[])Array.newInstance(array1.getClass().getComponentType(), maxElements);
        System.arraycopy(array1, 0, combinedArray, 0, array1.length);
        System.arraycopy(array2, 0, combinedArray, array1.length, maxElements - array1.length);
        return combinedArray;
    }
}

