/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook;

import com.deliveredtechnologies.rulebook.Fact;
import com.deliveredtechnologies.rulebook.FactMap;
import com.deliveredtechnologies.rulebook.Rule;
import com.deliveredtechnologies.rulebook.RuleState;
import com.deliveredtechnologies.rulebook.util.ArrayUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class StandardRule<T>
implements Rule<T> {
    private static Logger LOGGER = LoggerFactory.getLogger(StandardRule.class);
    private Class<T> _factType;
    private Optional<Rule<T>> _nextRule = Optional.empty();
    private FactMap _facts = new FactMap();
    private Predicate<FactMap<T>> _test;
    private List<Object> _actionChain = new ArrayList<Object>();
    private Map<Integer, List<String>> _factNameMap = new HashMap<Integer, List<String>>();
    private RuleState _ruleState = RuleState.NEXT;

    public static <T> StandardRule<T> create(Class<T> factType) {
        return new StandardRule<T>(factType);
    }

    public static StandardRule<Object> create() {
        return new StandardRule<Object>(Object.class);
    }

    protected StandardRule() {
    }

    public StandardRule(Class<T> clazz) {
        this();
        this._factType = clazz;
    }

    @Override
    public void run(Object ... otherArgs) {
        try {
            FactMap typeFilteredFacts = new FactMap(this._facts.values().stream().filter(fact -> this._factType.isAssignableFrom(((Fact)fact).getValue().getClass())).collect(Collectors.toMap(fact -> ((Fact)fact).getName(), fact -> (Fact)fact)));
            if (this.getWhen() == null || this.getWhen().test(typeFilteredFacts)) {
                List<Object> actionList = this.getThen();
                for (int i = 0; i < this.getThen().size(); ++i) {
                    Object action = actionList.get(i);
                    List<String> factNames = this._factNameMap.get(i);
                    FactMap usingFacts = factNames != null ? new FactMap(factNames.stream().filter(typeFilteredFacts::containsKey).collect(Collectors.toMap(name -> name, name -> this._facts.get(name)))) : typeFilteredFacts;
                    Stream.of(action.getClass().getMethods()).filter(method -> method.getName().equals("accept")).findFirst().ifPresent(method -> {
                        try {
                            method.setAccessible(true);
                            method.invoke(action, ArrayUtils.combine(new Object[]{usingFacts}, otherArgs, method.getParameterCount()));
                        }
                        catch (IllegalAccessException | InvocationTargetException err) {
                            LOGGER.error("Error invoking action on " + action.getClass(), (Throwable)err);
                        }
                    });
                }
                if (this._ruleState == RuleState.BREAK) {
                    return;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error occurred when trying to evaluate rule!", (Throwable)ex);
        }
        this._nextRule.ifPresent(rule -> rule.given(this._facts));
        this._nextRule.ifPresent(Rule::run);
    }

    @Override
    public Rule<T> given(String name, T value) {
        this._facts.put(name, new Fact<T>(name, value));
        return this;
    }

    @Override
    public Rule<T> given(Fact<T> ... facts) {
        for (Fact<T> f : facts) {
            this._facts.put(f.getName(), f);
        }
        return this;
    }

    @Override
    public Rule<T> given(List<Fact<T>> facts) {
        for (Fact<T> f : facts) {
            this._facts.put(f.getName(), f);
        }
        return this;
    }

    @Override
    public Rule<T> given(FactMap<T> facts) {
        this._facts = facts;
        return this;
    }

    @Override
    public Rule<T> givenUnTyped(FactMap facts) {
        this._facts = facts;
        return this;
    }

    @Override
    public FactMap getFactMap() {
        return this._facts;
    }

    @Override
    public Rule<T> when(Predicate<FactMap<T>> test) {
        this._test = test;
        return this;
    }

    @Override
    public Rule<T> then(Consumer<FactMap<T>> action) {
        this._actionChain.add(action);
        return this;
    }

    @Override
    public Rule<T> stop() {
        this._ruleState = RuleState.BREAK;
        return this;
    }

    @Override
    public StandardRule<T> using(String ... factNames) {
        List factNameList = Stream.of(factNames).filter(name -> this._factType.isInstance(this._facts.getValue((String)name))).collect(Collectors.toList());
        if (this._factNameMap.containsKey(this.getThen().size())) {
            List<String> existingFactNames = this._factNameMap.get(this.getThen().size());
            existingFactNames.addAll(factNameList);
            return this;
        }
        this._factNameMap.put(this.getThen().size(), factNameList);
        return this;
    }

    @Override
    public void setNextRule(Rule<T> rule) {
        this._nextRule = Optional.ofNullable(rule);
    }

    @Override
    public Predicate<FactMap<T>> getWhen() {
        return this._test;
    }

    @Override
    public List<Object> getThen() {
        return this._actionChain;
    }
}

