/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.model;

import com.deliveredtechnologies.rulebook.NameValueReferable;
import com.deliveredtechnologies.rulebook.NameValueReferableMap;
import com.deliveredtechnologies.rulebook.NameValueReferableTypeConvertibleMap;
import com.deliveredtechnologies.rulebook.Result;
import com.deliveredtechnologies.rulebook.RuleState;
import com.deliveredtechnologies.rulebook.model.Auditable;
import com.deliveredtechnologies.rulebook.model.Auditor;
import com.deliveredtechnologies.rulebook.model.Rule;
import com.deliveredtechnologies.rulebook.model.RuleException;
import com.deliveredtechnologies.rulebook.model.RuleStatus;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class AuditableRule<T, U>
implements Rule<T, U>,
Auditable {
    private Rule<T, U> _rule;
    private String _name = this.getClass().getSimpleName();
    private Auditor _auditor;

    public AuditableRule(Rule<T, U> rule) {
        this._rule = rule;
    }

    public AuditableRule(Rule<T, U> rule, String name) {
        this(rule);
        this._name = name;
    }

    @Override
    public void addFacts(NameValueReferable ... facts) {
        this._rule.addFacts(facts);
    }

    @Override
    public void addFacts(NameValueReferableMap facts) {
        this._rule.addFacts(facts);
    }

    @Override
    public void setFacts(NameValueReferableMap facts) {
        this._rule.setFacts(facts);
    }

    @Override
    public void setCondition(Predicate<NameValueReferableTypeConvertibleMap<T>> condition) {
        this._rule.setCondition(condition);
    }

    @Override
    public void setRuleState(RuleState ruleState) {
        this._rule.setRuleState(ruleState);
    }

    @Override
    public void addAction(Consumer<NameValueReferableTypeConvertibleMap<T>> action) {
        this._rule.addAction(action);
    }

    @Override
    public void addAction(BiConsumer<NameValueReferableTypeConvertibleMap<T>, Result<U>> action) {
        this._rule.addAction(action);
    }

    @Override
    public void addFactNameFilter(String ... factNames) {
        this._rule.addFactNameFilter(factNames);
    }

    @Override
    public NameValueReferableMap getFacts() {
        return this._rule.getFacts();
    }

    @Override
    public Predicate<NameValueReferableTypeConvertibleMap<T>> getCondition() {
        return this._rule.getCondition();
    }

    @Override
    public RuleState getRuleState() {
        return this._rule.getRuleState();
    }

    @Override
    public List<Object> getActions() {
        return this._rule.getActions();
    }

    @Override
    public boolean invoke(NameValueReferableMap facts) {
        boolean isPassing;
        try {
            isPassing = this._rule.invoke(facts);
            if (this._rule.getRuleState().equals((Object)RuleState.EXCEPTION)) {
                this._auditor.updateRuleStatus(this, RuleStatus.ERROR);
            } else {
                this._auditor.updateRuleStatus(this, isPassing ? RuleStatus.EXECUTED : RuleStatus.SKIPPED);
            }
        }
        catch (RuleException ex) {
            this._auditor.updateRuleStatus(this, RuleStatus.ERROR);
            throw ex;
        }
        return isPassing;
    }

    @Override
    public void setResult(Result<U> result) {
        this._rule.setResult(result);
    }

    @Override
    public Optional<Result<U>> getResult() {
        return this._rule.getResult();
    }

    @Override
    public void setAuditor(Auditor auditor) {
        this._auditor = auditor;
        this._auditor.registerRule(this);
    }

    @Override
    public String getName() {
        return this._name;
    }
}

