/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.model;

import com.deliveredtechnologies.rulebook.model.Auditable;
import com.deliveredtechnologies.rulebook.model.RuleStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public abstract class Auditor {
    protected Map<String, Map<Long, RuleStatus>> _auditMap = new HashMap<String, Map<Long, RuleStatus>>();
    private final ReentrantReadWriteLock _lock = new ReentrantReadWriteLock();

    public void registerRule(Auditable rule) {
        this._lock.writeLock().lock();
        try {
            this._auditMap.put(rule.getName(), new HashMap());
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRuleStatus(Auditable rule, RuleStatus status) {
        block6: {
            this._lock.readLock().lock();
            try {
                if (!this._auditMap.containsKey(rule.getName())) break block6;
                this._lock.readLock().unlock();
                this._lock.writeLock().lock();
                try {
                    this._auditMap.get(rule.getName()).put(Thread.currentThread().getId(), status);
                    this._lock.readLock().lock();
                }
                finally {
                    this._lock.writeLock().unlock();
                }
            }
            finally {
                this._lock.readLock().unlock();
            }
        }
    }

    public RuleStatus getRuleStatus(String name) {
        return this.getRuleStatusMap().getOrDefault(name, RuleStatus.NONE);
    }

    public Map<String, RuleStatus> getRuleStatusMap() {
        this._lock.readLock().lock();
        try {
            Map<String, RuleStatus> map = this._auditMap.keySet().stream().collect(Collectors.toMap(key -> key, key -> this._auditMap.get(key).getOrDefault(Thread.currentThread().getId(), RuleStatus.PENDING)));
            return map;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }
}

