/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.model.runner;

import com.deliveredtechnologies.rulebook.Result;
import com.deliveredtechnologies.rulebook.annotation.Rule;
import com.deliveredtechnologies.rulebook.model.RuleBook;
import com.deliveredtechnologies.rulebook.model.rulechain.cor.CoRRuleBook;
import com.deliveredtechnologies.rulebook.model.runner.AbstractRuleBookRunner;
import com.deliveredtechnologies.rulebook.util.AnnotationUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBookRunner
extends AbstractRuleBookRunner {
    private static Logger LOGGER = LoggerFactory.getLogger(RuleBookRunner.class);
    private String _package;
    private Predicate<String> _subPkgMatch;
    private Class<? extends RuleBook> _prototypeClass;
    private final ReentrantReadWriteLock _lock = new ReentrantReadWriteLock();
    private Optional<List<Class<?>>> _rules = Optional.ofNullable(null);
    private Result _result = new Result(null);

    public RuleBookRunner(String rulePackage) {
        this(rulePackage, (String s) -> s.startsWith(rulePackage));
    }

    public RuleBookRunner(String rulePackage, Predicate<String> subPkgMatch) {
        this(CoRRuleBook.class, rulePackage, subPkgMatch);
    }

    public RuleBookRunner(Class<? extends RuleBook> ruleBookClass, String rulePackage) {
        this(ruleBookClass, rulePackage, s -> s.startsWith(rulePackage));
    }

    public RuleBookRunner(Class<? extends RuleBook> ruleBookClass, String rulePackage, Predicate<String> subPkgMatch) {
        super(ruleBookClass);
        this._prototypeClass = ruleBookClass;
        this._package = rulePackage;
        this._subPkgMatch = subPkgMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Class<?>> getPojoRules() {
        this._lock.readLock().lock();
        try {
            if (this._rules.isPresent()) {
                List<Class<?>> list = this._rules.get();
                return list;
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
        this._lock.writeLock().lock();
        try {
            if (this._rules.isPresent()) {
                List<Class<?>> list = this._rules.get();
                return list;
            }
            Reflections reflections = new Reflections(this._package, new Scanner[0]);
            List rules = reflections.getTypesAnnotatedWith(Rule.class).stream().filter(rule -> rule.getAnnotatedSuperclass() != null).filter(rule -> this._subPkgMatch.test(rule.getPackage().getName())).collect(Collectors.toList());
            rules.sort(Comparator.comparingInt(aClass -> AnnotationUtils.getAnnotation(Rule.class, aClass).order()));
            this._rules = Optional.of(rules);
            List<Class<?>> list = this._rules.get();
            return list;
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }
}

