/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook;

import com.deliveredtechnologies.rulebook.Fact;
import com.deliveredtechnologies.rulebook.NameValueReferable;
import com.deliveredtechnologies.rulebook.NameValueReferableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class FactMap<T>
implements NameValueReferableMap<T> {
    private Map<String, NameValueReferable<T>> _facts;

    public FactMap(Map<String, NameValueReferable<T>> facts) {
        this._facts = facts;
    }

    public FactMap() {
        this._facts = new HashMap<String, NameValueReferable<T>>();
    }

    @Override
    public T getOne() {
        if (this._facts.size() == 1) {
            return this._facts.values().iterator().next().getValue();
        }
        return null;
    }

    @Override
    public T getValue(String name) {
        return Optional.ofNullable(this._facts.get(name)).map(NameValueReferable::getValue).orElse(null);
    }

    @Deprecated
    public String getStrVal(String name) {
        if (this.getValue(name) instanceof String) {
            return (String)this.getValue(name);
        }
        return String.valueOf(this.getValue(name));
    }

    @Deprecated
    public Integer getIntVal(String name) {
        T value = this.getValue(name);
        if (value != null) {
            if (Integer.class == value.getClass()) {
                return (Integer)value;
            }
            if (value.getClass() == String.class) {
                return Integer.valueOf((String)value);
            }
        }
        return null;
    }

    @Deprecated
    public Double getDblVal(String name) {
        T value = this.getValue(name);
        if (value != null) {
            if (Float.class == value.getClass()) {
                return ((Float)value).floatValue();
            }
            if (Double.class == value.getClass()) {
                return (Double)value;
            }
            if (Integer.class == value.getClass()) {
                return (double)((Integer)value);
            }
            if (Long.class == value.getClass()) {
                return (double)((Long)value);
            }
            if (String.class == value.getClass()) {
                return Double.parseDouble((String)value);
            }
        }
        return null;
    }

    @Override
    public void setValue(String name, T value) {
        NameValueReferable<T> fact = this._facts.get(name);
        if (fact == null) {
            fact = new Fact<T>(name, value);
            this._facts.put(name, fact);
            return;
        }
        fact.setValue(value);
    }

    @Override
    public Fact<T> put(NameValueReferable<T> fact) {
        return this.put(fact.getName(), fact);
    }

    @Override
    public Fact<T> put(String key, NameValueReferable<T> fact) {
        Optional<NameValueReferable<NameValueReferable>> prev = Optional.ofNullable(this._facts.put(key, fact));
        return prev.map(obj -> obj instanceof Fact ? (Fact)obj : new Fact(obj)).orElse(null);
    }

    @Override
    public int size() {
        return this._facts.size();
    }

    @Override
    public boolean isEmpty() {
        return this._facts.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._facts.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._facts.containsValue(value);
    }

    @Override
    public Fact<T> get(Object key) {
        NameValueReferable<T> obj = this._facts.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Fact) {
            return (Fact)obj;
        }
        return new Fact<T>(obj);
    }

    @Override
    public Fact<T> remove(Object key) {
        NameValueReferable<T> obj = this._facts.remove(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Fact) {
            return (Fact)obj;
        }
        return new Fact<T>(obj);
    }

    @Override
    public void putAll(Map<? extends String, ? extends NameValueReferable<T>> map) {
        this._facts.putAll(map);
    }

    @Override
    public void clear() {
        this._facts.clear();
    }

    @Override
    public Set<String> keySet() {
        return this._facts.keySet();
    }

    @Override
    public Collection<NameValueReferable<T>> values() {
        return this._facts.values();
    }

    @Override
    public Set<Map.Entry<String, NameValueReferable<T>>> entrySet() {
        return this._facts.entrySet();
    }

    public String toString() {
        return this._facts.size() == 1 ? this.getOne().toString() : this._facts.toString();
    }
}

