/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.lang;

import com.deliveredtechnologies.rulebook.lang.RuleBookRuleBuilder;
import com.deliveredtechnologies.rulebook.lang.TerminatingRuleBookBuilder;
import com.deliveredtechnologies.rulebook.model.Rule;
import com.deliveredtechnologies.rulebook.model.RuleBook;
import com.deliveredtechnologies.rulebook.model.rulechain.cor.CoRRuleBook;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBookBuilder<T>
implements TerminatingRuleBookBuilder<T> {
    private static Logger LOGGER = LoggerFactory.getLogger(RuleBookBuilder.class);
    private RuleBook<T> _ruleBook;
    private Class<? extends RuleBook> _ruleBookClass;
    private Class<?> _resultType = Object.class;

    public static RuleBookBuilder<Object> create() {
        return new RuleBookBuilder<Object>(CoRRuleBook.class);
    }

    public static RuleBookBuilder<Object> create(Class<? extends RuleBook> ruleBookClass) {
        return new RuleBookBuilder<Object>(ruleBookClass);
    }

    private RuleBookBuilder(Class<? extends RuleBook> ruleBookClass) {
        this._ruleBookClass = ruleBookClass;
    }

    private RuleBookBuilder(RuleBookBuilder ruleBookBuilder) {
        this._resultType = ruleBookBuilder._resultType;
        this._ruleBookClass = ruleBookBuilder._ruleBookClass;
        this.newRuleBook();
    }

    private void newRuleBook() {
        if (this._ruleBook == null) {
            try {
                this._ruleBook = this._ruleBookClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                try {
                    Constructor<? extends RuleBook> constructor = this._ruleBookClass.getConstructor(Class.class);
                    this._ruleBook = constructor.newInstance(this._resultType);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new IllegalStateException("RuleBook of class " + this._ruleBookClass + " can not be instantiated", ex);
                }
            }
        }
    }

    public <U> RuleBookBuilder<U> withResultType(Class<U> resultType) {
        this._resultType = resultType;
        return new RuleBookBuilder<T>(this);
    }

    public RuleBookBuilder<T> withDefaultResult(T result) {
        this.newRuleBook();
        this._ruleBook.setDefaultResult(result);
        return this;
    }

    public RuleBookBuilder<T> addRule(Consumer<RuleBookRuleBuilder<T>> consumer) {
        this.newRuleBook();
        consumer.accept(new RuleBookRuleBuilder<T>(this._ruleBook));
        return this;
    }

    public <U> RuleBookBuilder<T> addRule(Rule<U, T> rule) {
        this.newRuleBook();
        this._ruleBook.addRule(rule);
        return this;
    }

    @Override
    public RuleBook<T> build() {
        this.newRuleBook();
        return this._ruleBook;
    }
}

