/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.model.rulechain.cor;

import com.deliveredtechnologies.rulebook.Result;
import com.deliveredtechnologies.rulebook.RuleState;
import com.deliveredtechnologies.rulebook.model.Rule;
import com.deliveredtechnologies.rulebook.model.rulechain.cor.Handler;
import java.util.Optional;

public class RuleHandler
implements Handler<Rule> {
    private Rule _rule;
    private Handler<Rule> _successor;

    public RuleHandler(Rule rule) {
        this._rule = rule;
    }

    @Override
    public void handleRequest() {
        boolean actionResult = this._rule.invoke();
        if (!actionResult || this._rule.getRuleState() == RuleState.NEXT) {
            this.getSuccessor().ifPresent(handler -> {
                ((Rule)handler.getDelegate()).setFacts(this._rule.getFacts());
                this._rule.getResult().ifPresent(result -> ((Rule)handler.getDelegate()).setResult((Result)result));
            });
            this.getSuccessor().ifPresent(Handler::handleRequest);
        }
    }

    @Override
    public Rule getDelegate() {
        return this._rule;
    }

    @Override
    public Optional<Handler<Rule>> getSuccessor() {
        return Optional.ofNullable(this._successor);
    }

    @Override
    public Handler<Rule> setSuccessor(Handler<Rule> successor) {
        if (successor != null) {
            this._successor = successor;
        }
        return successor;
    }
}

