/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.model.runner;

import com.deliveredtechnologies.rulebook.NameValueReferable;
import com.deliveredtechnologies.rulebook.NameValueReferableMap;
import com.deliveredtechnologies.rulebook.Result;
import com.deliveredtechnologies.rulebook.RuleState;
import com.deliveredtechnologies.rulebook.annotation.Given;
import com.deliveredtechnologies.rulebook.annotation.Then;
import com.deliveredtechnologies.rulebook.annotation.When;
import com.deliveredtechnologies.rulebook.model.GoldenRule;
import com.deliveredtechnologies.rulebook.model.Rule;
import com.deliveredtechnologies.rulebook.util.AnnotationUtils;
import java.io.InvalidClassException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleAdapter
implements Rule {
    private static Logger LOGGER = LoggerFactory.getLogger(RuleAdapter.class);
    private Rule _rule;
    private Object _pojoRule;

    public RuleAdapter(Object pojoRule, Rule rule) throws InvalidClassException {
        if (AnnotationUtils.getAnnotation(com.deliveredtechnologies.rulebook.annotation.Rule.class, pojoRule.getClass()) == null) {
            throw new InvalidClassException(pojoRule.getClass() + " is not a Rule; missing @Rule annotation");
        }
        this._rule = rule;
        this._pojoRule = pojoRule;
    }

    public RuleAdapter(Object pojoRule) throws InvalidClassException {
        this(pojoRule, new GoldenRule(Object.class));
    }

    @Override
    public void addFacts(NameValueReferable ... facts) {
        this._rule.addFacts(facts);
        this.mapGivenFactsToProperties();
    }

    @Override
    public void addFacts(NameValueReferableMap facts) {
        this._rule.addFacts(facts);
        this.mapGivenFactsToProperties();
    }

    @Override
    public void setFacts(NameValueReferableMap facts) {
        this._rule.setFacts(facts);
        this.mapGivenFactsToProperties();
    }

    public void setCondition(Predicate condition) throws IllegalStateException {
        this._rule.setCondition(condition);
    }

    @Override
    public void setRuleState(RuleState ruleState) {
        this._rule.setRuleState(ruleState);
    }

    public void addAction(Consumer action) {
        this._rule.addAction(action);
    }

    public void addAction(BiConsumer action) {
        this._rule.addAction(action);
    }

    @Override
    public void addFactNameFilter(String ... factNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameValueReferableMap getFacts() {
        return this._rule.getFacts();
    }

    public Predicate<NameValueReferableMap> getCondition() {
        if (this._rule.getCondition() != null) {
            return this._rule.getCondition();
        }
        this._rule.setCondition(Arrays.stream(this._pojoRule.getClass().getMethods()).filter(method -> method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class).filter(method -> Arrays.stream(method.getDeclaredAnnotations()).anyMatch(When.class::isInstance)).findFirst().map(method -> object -> {
            try {
                return (Boolean)method.invoke(this._pojoRule, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                return false;
            }
        }).orElse(o -> true));
        return this._rule.getCondition();
    }

    @Override
    public RuleState getRuleState() {
        return this._rule.getRuleState();
    }

    @Override
    public List<Object> getActions() {
        if (this._rule.getActions().size() < 1) {
            ArrayList<Consumer<Object>> actionList = new ArrayList<Consumer<Object>>();
            for (Method actionMethod : AnnotationUtils.getAnnotatedMethods(Then.class, this._pojoRule.getClass())) {
                actionMethod.setAccessible(true);
                Consumer<Object> then = this.getThenMethodAsBiConsumer(actionMethod).map(Object.class::cast).orElse(this.getThenMethodAsConsumer(actionMethod).orElse(factMap -> {}));
                actionList.add(then);
            }
            this._rule.getActions().addAll(actionList);
        }
        return this._rule.getActions();
    }

    @Override
    public boolean invoke() {
        this.getActions();
        this.getCondition();
        return this._rule.invoke();
    }

    public void setResult(Result result) {
        this._rule.setResult(result);
        AnnotationUtils.getAnnotatedField(com.deliveredtechnologies.rulebook.annotation.Result.class, this._pojoRule.getClass()).ifPresent(field -> {
            field.setAccessible(true);
            try {
                field.set(this._pojoRule, result.getValue());
            }
            catch (Exception ex) {
                LOGGER.error("Unable to set @Result field in " + this._pojoRule.getClass(), (Throwable)ex);
            }
        });
    }

    public Optional<Result> getResult() {
        return this._rule.getResult();
    }

    private void mapGivenFactsToProperties() {
        for (Field field : AnnotationUtils.getAnnotatedFields(Given.class, this._pojoRule.getClass())) {
            Given given = field.getAnnotation(Given.class);
            try {
                field.setAccessible(true);
                if (NameValueReferable.class.isAssignableFrom(field.getType())) {
                    field.set(this._pojoRule, this.getFacts().get(given.value()));
                    continue;
                }
                Object value = this.getFacts().getValue(given.value());
                if (value != null) {
                    field.set(this._pojoRule, value);
                    continue;
                }
                if (NameValueReferableMap.class.isAssignableFrom(field.getType())) {
                    field.set(this._pojoRule, this.getFacts());
                    continue;
                }
                if (Collection.class.isAssignableFrom(field.getType())) {
                    Stream<Object> stream = this.getFacts().values().stream().filter(fact -> {
                        ParameterizedType paramType = (ParameterizedType)field.getGenericType();
                        Class genericType = (Class)paramType.getActualTypeArguments()[0];
                        return genericType.equals(((NameValueReferable)fact).getValue().getClass());
                    }).map(fact -> {
                        ParameterizedType paramType = (ParameterizedType)field.getGenericType();
                        Class genericType = (Class)paramType.getActualTypeArguments()[0];
                        return genericType.cast(((NameValueReferable)fact).getValue());
                    });
                    if (List.class == field.getType()) {
                        field.set(this._pojoRule, stream.collect(Collectors.toList()));
                        continue;
                    }
                    if (Set.class != field.getType()) continue;
                    field.set(this._pojoRule, stream.collect(Collectors.toSet()));
                    continue;
                }
                if (Map.class != field.getType()) continue;
                Map<Object, Object> map = this.getFacts().keySet().stream().filter(key -> {
                    ParameterizedType paramType = (ParameterizedType)field.getGenericType();
                    Class genericType = (Class)paramType.getActualTypeArguments()[1];
                    return genericType.equals(this.getFacts().getValue((String)key).getClass());
                }).collect(Collectors.toMap(key -> key, key -> this.getFacts().getValue((String)key)));
                field.set(this._pojoRule, map);
            }
            catch (Exception ex) {
                LOGGER.error("Unable to update field '" + field.getName() + "' in rule object '" + this._pojoRule.getClass() + "'");
            }
        }
    }

    private Optional<BiConsumer> getThenMethodAsBiConsumer(Method method) {
        return AnnotationUtils.getAnnotatedField(com.deliveredtechnologies.rulebook.annotation.Result.class, this._pojoRule.getClass()).map(resultField -> (facts, result) -> {
            try {
                Object retVal = method.invoke(this._pojoRule, new Object[0]);
                if (method.getReturnType() == RuleState.class && retVal == RuleState.BREAK) {
                    this._rule.setRuleState(RuleState.BREAK);
                }
                resultField.setAccessible(true);
                Object resultVal = resultField.get(this._pojoRule);
                ((Result)result).setValue(resultVal);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                LOGGER.error("Unable to access " + this._pojoRule.getClass().getName() + " when converting then to BiConsumer", (Throwable)ex);
            }
        });
    }

    private Optional<Consumer> getThenMethodAsConsumer(Method method) {
        if (!AnnotationUtils.getAnnotatedField(com.deliveredtechnologies.rulebook.annotation.Result.class, this._pojoRule.getClass()).isPresent()) {
            return Optional.of(obj -> {
                try {
                    Object retVal = method.invoke(this._pojoRule, new Object[0]);
                    if (method.getReturnType() == RuleState.class && retVal == RuleState.BREAK) {
                        this._rule.setRuleState(RuleState.BREAK);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    LOGGER.error("Unable to access " + this._pojoRule.getClass().getName() + " when converting then to Consumer", (Throwable)ex);
                }
            });
        }
        return Optional.empty();
    }
}

