/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.model.runner;

import com.deliveredtechnologies.rulebook.NameValueReferableMap;
import com.deliveredtechnologies.rulebook.Result;
import com.deliveredtechnologies.rulebook.model.Rule;
import com.deliveredtechnologies.rulebook.model.RuleBook;
import com.deliveredtechnologies.rulebook.model.rulechain.cor.CoRRuleBook;
import com.deliveredtechnologies.rulebook.model.runner.RuleAdapter;
import com.deliveredtechnologies.rulebook.util.AnnotationUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBookRunner
implements RuleBook {
    private static Logger LOGGER = LoggerFactory.getLogger(RuleBookRunner.class);
    private RuleBook _ruleBook;
    private String _package;

    public RuleBookRunner(String rulePackage) {
        this(new CoRRuleBook(), rulePackage);
    }

    public RuleBookRunner(RuleBook ruleBook, String rulePackage) {
        this._ruleBook = ruleBook;
        this._package = rulePackage;
    }

    @Override
    public void addRule(Rule rule) {
        this._ruleBook.addRule(rule);
    }

    @Override
    public void run(NameValueReferableMap facts) {
        if (!this.hasRules()) {
            this.defineRules();
        }
        this._ruleBook.run(facts);
    }

    public void setDefaultResult(Object result) {
        this._ruleBook.setDefaultResult(result);
    }

    public Optional<Result> getResult() {
        return this._ruleBook.getResult();
    }

    @Override
    public void defineRules() {
        try {
            List<Class<?>> classes = this.findRuleClassesInPackage(this._package);
            for (Class<?> rule : classes) {
                try {
                    AnnotationUtils.getAnnotatedField(com.deliveredtechnologies.rulebook.annotation.Result.class, rule).ifPresent(field -> {
                        if (!this.getResult().isPresent()) {
                            this.setDefaultResult(new Object());
                        }
                    });
                    this.addRule(new RuleAdapter(rule.newInstance()));
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    LOGGER.warn("Unable to create instance of rule using '" + rule + "'", (Throwable)ex);
                }
            }
        }
        catch (IOException | InvalidPathException ex) {
            LOGGER.error("Unable to find rule classes in package '" + this._package + "'", (Throwable)ex);
        }
    }

    @Override
    public boolean hasRules() {
        return this._ruleBook.hasRules();
    }

    private List<Class<?>> findRuleClassesInPackage(String packageName) throws InvalidPathException, IOException {
        String pathName = packageName.replace(".", "/");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL pathUrl = classLoader.getResource(pathName);
        if (pathUrl == null) {
            throw new InvalidPathException("'" + packageName + "' cannot be found by the ClassLoader", packageName);
        }
        try {
            Path path = Paths.get(pathUrl.toURI());
            if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
                throw new InvalidPathException("'" + packageName + "' is not a valid path", packageName);
            }
            ArrayList classes = new ArrayList();
            Files.walk(path, 1, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0])).forEach(p -> {
                String fileName = p.getFileName().toString();
                String className = fileName.substring(0, fileName.length() - 6);
                try {
                    Class<?> ruleClass = Class.forName(packageName + "." + className);
                    if (AnnotationUtils.getAnnotation(com.deliveredtechnologies.rulebook.annotation.Rule.class, ruleClass) != null) {
                        classes.add(ruleClass);
                    }
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Unable to resolve class for '" + packageName + "." + className + "'", (Throwable)e);
                }
            });
            classes.sort((class1, class2) -> AnnotationUtils.getAnnotation(com.deliveredtechnologies.rulebook.annotation.Rule.class, class1).order() - AnnotationUtils.getAnnotation(com.deliveredtechnologies.rulebook.annotation.Rule.class, class2).order());
            return classes;
        }
        catch (URISyntaxException ex) {
            throw new InvalidPathException("'" + packageName + "' is not a valid path", ex.getReason());
        }
    }
}

