/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.io;

import com.deliveredtechnologies.io.Executable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class CommandLine
implements Executable {
    private static int DEFAULT_TIMEOUT = 600000;
    private Path directory;
    private boolean inheritIO;
    private Logger logger;

    public CommandLine(Path directory) {
        this(directory, LoggerFactory.getLogger(CommandLine.class));
    }

    public CommandLine(Path directory, Logger logger) {
        this(directory, true, logger);
    }

    public CommandLine(Path directory, boolean inheritIO, Logger logger) {
        this.logger = logger;
        this.inheritIO = inheritIO;
        this.directory = directory;
    }

    @Override
    public String execute(String command, int timeout) throws IOException, InterruptedException {
        Optional<String> output;
        this.logger.info("*** directory: {} ***", (Object)this.getDirectory().toAbsolutePath());
        this.logger.info("*** command: {} ***", (Object)command);
        ProcessExecutor processExecutor = new ProcessExecutor();
        ArrayList<String> cmd = new ArrayList<String>(this.getShell());
        cmd.add(command);
        String[] baseCommand = command.split(" ");
        String baseCommandName = Paths.get(baseCommand[0], new String[0]).getFileName().toString();
        String loggerName = baseCommand.length >= 2 ? baseCommandName + "-" + baseCommand[1] : baseCommandName;
        try {
            output = Optional.ofNullable(processExecutor.command(cmd).directory(this.directory.toAbsolutePath().toFile()).redirectOutput((OutputStream)Slf4jStream.of((Logger)LoggerFactory.getLogger((String)loggerName)).asInfo()).timeout((long)timeout, TimeUnit.MILLISECONDS).readOutput(true).exitValueNormal().destroyOnExit().execute().outputString());
        }
        catch (TimeoutException e) {
            this.logger.error("Processed timed out", (Throwable)e);
            throw new InterruptedException(e.getMessage());
        }
        return output.orElse("");
    }

    @Override
    public String execute(String command) throws IOException, InterruptedException {
        return this.execute(command, DEFAULT_TIMEOUT);
    }

    private List<String> getShell() {
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        String shellPath = System.getProperty("shellPath", System.getenv().getOrDefault("SHELL_PATH", ""));
        List<String> shell = !shellPath.isEmpty() ? Arrays.asList(shellPath, shellPath.contains("cmd.exe") ? "/c" : "-c") : (isWindows ? Arrays.asList("cmd.exe", "/c") : Arrays.asList("bash", "-c"));
        return shell;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Path getDirectory() {
        return this.directory;
    }
}

