/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.terraform;

import com.deliveredtechnologies.io.CommandLine;
import com.deliveredtechnologies.io.Executable;
import com.deliveredtechnologies.terraform.TerraformCommand;
import com.deliveredtechnologies.terraform.TerraformException;
import com.deliveredtechnologies.terraform.TerraformPathResolver;
import com.deliveredtechnologies.terraform.TerraformUtils;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class TerraformCommandLineDecorator
implements Executable {
    private Executable commandLine;
    private TerraformCommand cmd;
    private Optional<Logger> logger = Optional.empty();
    private TerraformPathResolver terraformPathResolver = new TerraformPathResolver();

    public TerraformCommandLineDecorator(TerraformCommand cmd, Executable commandLine, Logger logger) {
        this.commandLine = commandLine;
        this.cmd = cmd;
        this.logger = Optional.ofNullable(logger);
        this.logger.ifPresent(log -> this.commandLine.setLogger((Logger)log));
    }

    public TerraformCommandLineDecorator(TerraformCommand cmd, Executable commandLine) {
        this(cmd, commandLine, null);
    }

    public TerraformCommandLineDecorator(TerraformCommand cmd, Logger logger) throws IOException {
        this(cmd, new CommandLine(TerraformUtils.getDefaultTerraformRootModuleDir()), logger);
    }

    public TerraformCommandLineDecorator(TerraformCommand cmd) throws IOException {
        this(cmd, new CommandLine(TerraformUtils.getDefaultTerraformRootModuleDir()));
    }

    public TerraformCommandLineDecorator(TerraformCommand cmd, String tfRootDir) throws IOException, TerraformException {
        this(cmd, new CommandLine(tfRootDir == null ? TerraformUtils.getDefaultTerraformRootModuleDir() : TerraformUtils.getTerraformRootModuleDir(tfRootDir)));
    }

    @Override
    public String execute(String command, int timeout) throws IOException, InterruptedException {
        return this.commandLine.execute(this.getTerraformCommand(command), timeout);
    }

    @Override
    public String execute(String command) throws IOException, InterruptedException {
        return this.commandLine.execute(this.getTerraformCommand(command));
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = Optional.ofNullable(logger);
        this.commandLine.setLogger(logger);
    }

    public void setTerraformPathResolver(TerraformPathResolver terraformPathResolver) {
        this.terraformPathResolver = terraformPathResolver;
    }

    public Executable getCommandLine() {
        return this.commandLine;
    }

    private String getTerraformCommand(String command) {
        return String.format("%s %s %s", this.terraformPathResolver.getPath(), this.cmd.toString(), StringUtils.isEmpty((CharSequence)command) ? "" : command);
    }
}

