/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.terraform;

import com.deliveredtechnologies.terraform.TerraformException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerraformUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerraformUtils.class);

    private TerraformUtils() {
    }

    public static Path getDefaultTerraformRootModuleDir() throws IOException {
        try {
            Path tfSourcePath = Paths.get("src", "main", "tf");
            if (tfSourcePath.toFile().exists() && tfSourcePath.toFile().isDirectory()) {
                return Files.walk(tfSourcePath, 2, new FileVisitOption[0]).filter(path -> !path.toFile().isDirectory()).filter(path -> path.getFileName().toString().endsWith(".tf")).findFirst().orElseThrow(() -> new IOException("Terraform root module not found")).getParent();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            LOGGER.info("Unable to determine default Terraform root module directory; using current directory.");
        }
        return Paths.get(".", new String[0]);
    }

    public static Path getTerraformRootModuleDir(String tfmodule) throws IOException, TerraformException {
        Path path = tfmodule.startsWith("tf-examples") ? Paths.get("src", "main", tfmodule) : (tfmodule.contains(File.separator) ? Paths.get(tfmodule, new String[0]) : Paths.get("src", "main", "tf", tfmodule));
        if (!path.toFile().exists()) {
            throw new TerraformException(String.format("%1$s does not exist", tfmodule));
        }
        return path;
    }

    public static Path getDefaultTfModulesDir() {
        return Paths.get("src", "main", ".tfmodules");
    }
}

